/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.database;

import javax.annotation.Nonnull;

public class FirewallRuleConfig {
    @Nonnull
    private String name;
    private String startIpAddress;
    private String endIpAddress;

    FirewallRuleConfig(@Nonnull String name, String startIpAddress, String endIpAddress) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        this.startIpAddress = startIpAddress;
        this.endIpAddress = endIpAddress;
    }

    public static FirewallRuleConfigBuilder builder() {
        return new FirewallRuleConfigBuilder();
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public String getStartIpAddress() {
        return this.startIpAddress;
    }

    public String getEndIpAddress() {
        return this.endIpAddress;
    }

    public static class FirewallRuleConfigBuilder {
        private String name;
        private String startIpAddress;
        private String endIpAddress;

        FirewallRuleConfigBuilder() {
        }

        public FirewallRuleConfigBuilder name(@Nonnull String name) {
            this.name = name;
            return this;
        }

        public FirewallRuleConfigBuilder startIpAddress(String startIpAddress) {
            this.startIpAddress = startIpAddress;
            return this;
        }

        public FirewallRuleConfigBuilder endIpAddress(String endIpAddress) {
            this.endIpAddress = endIpAddress;
            return this;
        }

        public FirewallRuleConfig build() {
            return new FirewallRuleConfig(this.name, this.startIpAddress, this.endIpAddress);
        }

        public String toString() {
            return "FirewallRuleConfig.FirewallRuleConfigBuilder(name=" + this.name + ", startIpAddress=" + this.startIpAddress + ", endIpAddress=" + this.endIpAddress + ")";
        }
    }
}

