/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.identities;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.msi.MsiManager;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluentcore.policy.ProviderRegistrationPolicy;
import com.azure.resourcemanager.resources.models.Providers;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzService;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.identities.AzureManagedIdentitySubscription;
import com.microsoft.azure.toolkit.lib.identities.Identity;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AzureManagedIdentity
extends AbstractAzService<AzureManagedIdentitySubscription, MsiManager> {
    public AzureManagedIdentity() {
        super("Microsoft.ManagedIdentity");
    }

    @Nonnull
    protected AzureManagedIdentitySubscription newResource(@Nonnull MsiManager eventHubsManager) {
        return new AzureManagedIdentitySubscription(eventHubsManager.subscriptionId(), this);
    }

    @Nullable
    protected MsiManager loadResourceFromAzure(@Nonnull String subscriptionId, String resourceGroup) {
        Account account = ((AzureAccount)Azure.az(AzureAccount.class)).account();
        String tenantId = account.getSubscription(subscriptionId).getTenantId();
        AzureConfiguration config = Azure.az().config();
        HttpLogOptions logOptions = new HttpLogOptions();
        logOptions.setLogLevel(Optional.ofNullable(config.getLogLevel()).map(HttpLogDetailLevel::valueOf).orElse(HttpLogDetailLevel.NONE));
        AzureProfile azureProfile = new AzureProfile(tenantId, subscriptionId, account.getEnvironment());
        Providers providers = ((ResourceManager.Configurable)((ResourceManager.Configurable)ResourceManager.configure().withHttpClient(AbstractAzServiceSubscription.getDefaultHttpClient())).withPolicy(AbstractAzServiceSubscription.getUserAgentPolicy())).authenticate(account.getTokenCredential(subscriptionId), azureProfile).withSubscription(subscriptionId).providers();
        return ((MsiManager.Configurable)((MsiManager.Configurable)((MsiManager.Configurable)((MsiManager.Configurable)MsiManager.configure().withHttpClient(AbstractAzServiceSubscription.getDefaultHttpClient())).withLogOptions(logOptions)).withPolicy(AbstractAzServiceSubscription.getUserAgentPolicy())).withPolicy((HttpPipelinePolicy)new ProviderRegistrationPolicy(providers))).authenticate(account.getTokenCredential(subscriptionId), azureProfile);
    }

    @Nonnull
    public List<Identity> identities() {
        return this.list().stream().flatMap(m -> m.identity().list().stream()).collect(Collectors.toList());
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Managed Identities";
    }

    public String getServiceNameForTelemetry() {
        return "identities";
    }
}

