/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.identities;

import com.azure.core.util.paging.ContinuablePage;
import com.azure.resourcemanager.msi.MsiManager;
import com.azure.resourcemanager.msi.models.Identities;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.identities.AzureManagedIdentitySubscription;
import com.microsoft.azure.toolkit.lib.identities.Identity;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class AzureManagedIdentityModule
extends AbstractAzResourceModule<Identity, AzureManagedIdentitySubscription, com.azure.resourcemanager.msi.models.Identity> {
    public static final String NAME = "userAssignedIdentities";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public AzureManagedIdentityModule(@Nonnull AzureManagedIdentitySubscription parent) {
        super(NAME, (AzResource)parent);
    }

    @Nonnull
    protected Iterator<? extends ContinuablePage<String, com.azure.resourcemanager.msi.models.Identity>> loadResourcePagesFromAzure() {
        return Optional.ofNullable(this.getClient()).map(c -> c.list().iterableByPage(AzureManagedIdentityModule.getPageSize()).iterator()).orElse(Collections.emptyIterator());
    }

    @Nullable
    @AzureOperation(name="azure/eventhubs.load_event_hubs_namespace.eventhubs", params={"name"})
    protected com.azure.resourcemanager.msi.models.Identity loadResourceFromAzure(@Nonnull String name, @Nullable String resourceGroup) {
        String string = name;
        String string2 = resourceGroup;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            assert (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{resourceGroup})) : "resource group can not be empty";
            com.azure.resourcemanager.msi.models.Identity identity = Optional.ofNullable(this.getClient()).map(eventHubNamespaces -> (com.azure.resourcemanager.msi.models.Identity)eventHubNamespaces.getByResourceGroup(resourceGroup, name)).orElse(null);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return identity;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/eventhubs.delete_event_hubs_namespace.eventhubs", params={"nameFromResourceId(resourceId)"})
    protected void deleteResourceFromAzure(@Nonnull String resourceId) {
        String string = resourceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Optional.ofNullable(this.getClient()).ifPresent(eventHubNamespaces -> eventHubNamespaces.deleteById(resourceId));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    protected Identity newResource(@Nonnull com.azure.resourcemanager.msi.models.Identity remote) {
        return new Identity(remote, this);
    }

    @Nonnull
    protected Identity newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new Identity(name, Objects.requireNonNull(resourceGroupName), this);
    }

    @Nullable
    protected Identities getClient() {
        return Optional.ofNullable(((AzureManagedIdentitySubscription)this.parent).getRemote()).map(MsiManager::identities).orElse(null);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Managed Identities";
    }

    static {
        AzureManagedIdentityModule.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AzureManagedIdentityModule.java", AzureManagedIdentityModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "loadResourceFromAzure", "com.microsoft.azure.toolkit.lib.identities.AzureManagedIdentityModule", "java.lang.String:java.lang.String", "name:resourceGroup", "", "com.azure.resourcemanager.msi.models.Identity"), 39);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "deleteResourceFromAzure", "com.microsoft.azure.toolkit.lib.identities.AzureManagedIdentityModule", "java.lang.String", "resourceId", "", "void"), 46);
    }
}

