/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.monitor;

import com.azure.core.util.Context;
import com.azure.monitor.query.LogsQueryClient;
import com.azure.monitor.query.models.LogsQueryOptions;
import com.azure.monitor.query.models.LogsQueryResult;
import com.azure.monitor.query.models.LogsTable;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.models.Column;
import com.azure.resourcemanager.loganalytics.models.Workspace;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsServiceWorkspaceSubscription;
import com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsWorkspaceModule;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LogAnalyticsWorkspace
extends AbstractAzResource<LogAnalyticsWorkspace, LogAnalyticsServiceWorkspaceSubscription, Workspace>
implements Deletable {
    protected LogAnalyticsWorkspace(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull LogAnalyticsWorkspaceModule module) {
        super(name, resourceGroupName, (AbstractAzResourceModule)module);
    }

    protected LogAnalyticsWorkspace(@Nonnull LogAnalyticsWorkspace workspace) {
        super((AbstractAzResource)workspace);
    }

    protected LogAnalyticsWorkspace(@Nonnull Workspace remote, @Nonnull LogAnalyticsWorkspaceModule module) {
        super(remote.name(), ResourceId.fromString((String)remote.id()).resourceGroupName(), (AbstractAzResourceModule)module);
    }

    @Nullable
    public Region getRegion() {
        return Optional.ofNullable((Workspace)this.getRemote(new boolean[0])).map(workspace -> Region.fromName((String)workspace.regionName())).orElse(null);
    }

    @Nullable
    public String getCustomerId() {
        return Optional.ofNullable((Workspace)this.getRemote(new boolean[0])).map(Workspace::customerId).orElse(null);
    }

    @Nullable
    public String getPrimarySharedKeys() {
        LogAnalyticsManager remote = (LogAnalyticsManager)((LogAnalyticsServiceWorkspaceSubscription)this.getParent()).getRemote(new boolean[0]);
        return Optional.ofNullable(remote).map(LogAnalyticsManager::sharedKeysOperations).map(sharedKeysOperations -> sharedKeysOperations.getSharedKeys(this.getResourceGroupName(), this.getName()).primarySharedKey()).orElse(null);
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.emptyList();
    }

    @Nonnull
    public String loadStatus(@Nonnull Workspace remote) {
        return remote.provisioningState().toString();
    }

    @Nullable
    public LogsTable executeQuery(String queryString) {
        LogsQueryOptions options = new LogsQueryOptions().setServerTimeout(Duration.ofSeconds(10L));
        String workspaceId = this.getCustomerId();
        LogsQueryClient client = ((LogAnalyticsServiceWorkspaceSubscription)this.getParent()).getLosQueryClient();
        if (Objects.nonNull(workspaceId) && Objects.nonNull(client)) {
            return ((LogsQueryResult)client.queryWorkspaceWithResponse(workspaceId, queryString, null, options, Context.NONE).getValue()).getTable();
        }
        return null;
    }

    public List<String> getTableColumnNames(String tableName) {
        LogAnalyticsManager manager = (LogAnalyticsManager)((LogAnalyticsServiceWorkspaceSubscription)this.getParent()).getRemote(new boolean[0]);
        if (Objects.isNull(manager)) {
            return new ArrayList<String>();
        }
        return manager.tables().get(this.getResourceGroupName(), this.getName(), tableName).schema().standardColumns().stream().map(Column::name).collect(Collectors.toList());
    }
}

