/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.monitor;

import com.azure.core.util.paging.ContinuablePage;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.models.Workspace;
import com.azure.resourcemanager.loganalytics.models.Workspaces;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsServiceWorkspaceSubscription;
import com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsWorkspace;
import com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsWorkspaceDraft;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class LogAnalyticsWorkspaceModule
extends AbstractAzResourceModule<LogAnalyticsWorkspace, LogAnalyticsServiceWorkspaceSubscription, Workspace> {
    public static final String NAME = "workspaces";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public LogAnalyticsWorkspaceModule(@Nonnull LogAnalyticsServiceWorkspaceSubscription parent) {
        super(NAME, (AzResource)parent);
    }

    @Nonnull
    protected Iterator<? extends ContinuablePage<String, Workspace>> loadResourcePagesFromAzure() {
        return Optional.ofNullable(this.getClient()).map(c -> c.list().iterableByPage(LogAnalyticsWorkspaceModule.getPageSize()).iterator()).orElse(Collections.emptyIterator());
    }

    @Nullable
    @AzureOperation(name="azure/resource.load_resource.resource|type", params={"name", "this.getResourceTypeName()"})
    protected Workspace loadResourceFromAzure(@Nonnull String name, @Nullable String resourceGroup) {
        String string = name;
        String string2 = resourceGroup;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            assert (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{resourceGroup})) : "resource group can not be empty";
            Workspace workspace = Optional.ofNullable(this.getClient()).map(workspaces -> workspaces.getByResourceGroup(resourceGroup, name)).orElse(null);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return workspace;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/workspace.delete_log_analytics_workspace.workspace", params={"nameFromResourceId(resourceId)"})
    protected void deleteResourceFromAzure(@Nonnull String resourceId) {
        String string = resourceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Optional.ofNullable(this.getClient()).ifPresent(workspaces -> workspaces.deleteById(resourceId));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    protected LogAnalyticsWorkspaceDraft newDraftForCreate(@Nonnull String name, @Nullable String rgName) {
        assert (rgName != null) : "'Resource group' is required.";
        return new LogAnalyticsWorkspaceDraft(name, rgName, this);
    }

    @Nonnull
    protected LogAnalyticsWorkspaceDraft newDraftForUpdate(@Nonnull LogAnalyticsWorkspace workspace) {
        return new LogAnalyticsWorkspaceDraft(workspace);
    }

    @Nonnull
    protected LogAnalyticsWorkspace newResource(@Nonnull Workspace remote) {
        return new LogAnalyticsWorkspace(remote, this);
    }

    @Nonnull
    protected LogAnalyticsWorkspace newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new LogAnalyticsWorkspace(name, Objects.requireNonNull(resourceGroupName), this);
    }

    @Nullable
    protected Workspaces getClient() {
        return Optional.ofNullable((LogAnalyticsManager)((LogAnalyticsServiceWorkspaceSubscription)this.parent).getRemote()).map(LogAnalyticsManager::workspaces).orElse(null);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Log Analytics workspace";
    }

    static {
        LogAnalyticsWorkspaceModule.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LogAnalyticsWorkspaceModule.java", LogAnalyticsWorkspaceModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "loadResourceFromAzure", "com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsWorkspaceModule", "java.lang.String:java.lang.String", "name:resourceGroup", "", "com.azure.resourcemanager.loganalytics.models.Workspace"), 35);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "deleteResourceFromAzure", "com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsWorkspaceModule", "java.lang.String", "resourceId", "", "void"), 42);
    }
}

