/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.postgre;

import com.azure.core.util.paging.ContinuablePage;
import com.azure.resourcemanager.postgresql.PostgreSqlManager;
import com.azure.resourcemanager.postgresql.models.FirewallRule;
import com.azure.resourcemanager.postgresql.models.FirewallRules;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.google.common.base.Preconditions;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.database.entity.IFirewallRule;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlFirewallRule;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlFirewallRuleDraft;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlServer;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlServiceSubscription;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class PostgreSqlFirewallRuleModule
extends AbstractAzResourceModule<PostgreSqlFirewallRule, PostgreSqlServer, FirewallRule> {
    public static final String NAME = "firewallRules";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public PostgreSqlFirewallRuleModule(@Nonnull PostgreSqlServer parent) {
        super(NAME, (AzResource)parent);
    }

    @Nonnull
    protected PostgreSqlFirewallRule newResource(@Nonnull FirewallRule rule) {
        return new PostgreSqlFirewallRule(rule, this);
    }

    @Nonnull
    protected PostgreSqlFirewallRule newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new PostgreSqlFirewallRule(name, this);
    }

    @Nonnull
    protected Iterator<? extends ContinuablePage<String, FirewallRule>> loadResourcePagesFromAzure() {
        PostgreSqlServer p = (PostgreSqlServer)this.getParent();
        return Optional.ofNullable(this.getClient()).map(c -> c.listByServer(p.getResourceGroupName(), p.getName()).iterableByPage(PostgreSqlFirewallRuleModule.getPageSize()).iterator()).orElse(Collections.emptyIterator());
    }

    @Nonnull
    @AzureOperation(name="azure/resource.load_resources.type", params={"this.getResourceTypeName()"})
    protected Stream<FirewallRule> loadResourcesFromAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            PostgreSqlServer p = (PostgreSqlServer)this.getParent();
            Stream<FirewallRule> stream = Optional.ofNullable(this.getClient()).map(c -> c.listByServer(p.getResourceGroupName(), p.getName()).stream()).orElse(Stream.empty());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return stream;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nullable
    @AzureOperation(name="azure/resource.load_resource.resource|type", params={"name", "this.getResourceTypeName()"})
    protected FirewallRule loadResourceFromAzure(@Nonnull String name, String resourceGroup) {
        String string = name;
        String string2 = resourceGroup;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            PostgreSqlServer p = (PostgreSqlServer)this.getParent();
            FirewallRule firewallRule = Optional.ofNullable(this.getClient()).map(c -> c.get(p.getResourceGroupName(), p.getName(), name)).orElse(null);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return firewallRule;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/postgre.delete_firewall_rule.rule", params={"nameFromResourceId(id)"})
    protected void deleteResourceFromAzure(@Nonnull String id) {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            PostgreSqlServer p = (PostgreSqlServer)this.getParent();
            ResourceId resourceId = ResourceId.fromString((String)id);
            String name = resourceId.name();
            Optional.ofNullable(this.getClient()).ifPresent(c -> c.delete(p.getResourceGroupName(), p.getName(), name));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    protected PostgreSqlFirewallRuleDraft newDraftForCreate(@Nonnull String name, @Nullable String resourceGroupName) {
        assert (resourceGroupName != null) : "'Resource group' is required.";
        return new PostgreSqlFirewallRuleDraft(name, this);
    }

    @Nonnull
    protected PostgreSqlFirewallRuleDraft newDraftForUpdate(@Nonnull PostgreSqlFirewallRule origin) {
        return new PostgreSqlFirewallRuleDraft(origin);
    }

    @Nullable
    protected FirewallRules getClient() {
        return Optional.ofNullable((PostgreSqlManager)((PostgreSqlServiceSubscription)((PostgreSqlServer)this.getParent()).getParent()).getRemote(new boolean[0])).map(PostgreSqlManager::firewallRules).orElse(null);
    }

    void toggleAzureServiceAccess(boolean allowed) {
        String ruleName = "AllowAllWindowsAzureIps";
        String rgName = ((PostgreSqlServer)this.getParent()).getResourceGroupName();
        boolean exists = this.exists("AllowAllWindowsAzureIps", rgName);
        if (!allowed && exists) {
            this.delete("AllowAllWindowsAzureIps", rgName);
        }
        if (allowed && !exists) {
            PostgreSqlFirewallRuleDraft draft = (PostgreSqlFirewallRuleDraft)this.create("AllowAllWindowsAzureIps", rgName);
            draft.setStartIpAddress("0.0.0.0");
            draft.setEndIpAddress("0.0.0.0");
            draft.commit();
        }
    }

    void toggleLocalMachineAccess(boolean allowed) {
        String ruleName = IFirewallRule.getLocalMachineAccessRuleName();
        String rgName = ((PostgreSqlServer)this.getParent()).getResourceGroupName();
        boolean exists = this.exists(ruleName, rgName);
        if (!allowed && exists) {
            this.delete(ruleName, rgName);
        }
        if (allowed && !exists) {
            String publicIp = ((PostgreSqlServer)this.getParent()).getLocalMachinePublicIp();
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)publicIp), (Object)"Cannot enable local machine access to PostgreSql server due to error: cannot get public ip.");
            PostgreSqlFirewallRuleDraft draft = (PostgreSqlFirewallRuleDraft)this.updateOrCreate(ruleName, rgName);
            draft.setStartIpAddress(publicIp);
            draft.setEndIpAddress(publicIp);
            draft.commit();
        }
    }

    @Nonnull
    public String getResourceTypeName() {
        return "PostgreSQL firewall rule";
    }

    static {
        PostgreSqlFirewallRuleModule.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PostgreSqlFirewallRuleModule.java", PostgreSqlFirewallRuleModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "loadResourcesFromAzure", "com.microsoft.azure.toolkit.lib.postgre.PostgreSqlFirewallRuleModule", "", "", "", "java.util.stream.Stream"), 58);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "loadResourceFromAzure", "com.microsoft.azure.toolkit.lib.postgre.PostgreSqlFirewallRuleModule", "java.lang.String:java.lang.String", "name:resourceGroup", "", "com.azure.resourcemanager.postgresql.models.FirewallRule"), 66);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "deleteResourceFromAzure", "com.microsoft.azure.toolkit.lib.postgre.PostgreSqlFirewallRuleModule", "java.lang.String", "id", "", "void"), 73);
    }
}

