/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.postgre;

import com.azure.resourcemanager.postgresql.PostgreSqlManager;
import com.azure.resourcemanager.postgresql.models.PerformanceTierProperties;
import com.azure.resourcemanager.postgresql.models.PerformanceTierServiceLevelObjectives;
import com.azure.resourcemanager.postgresql.models.Server;
import com.azure.resourcemanager.postgresql.models.ServerPropertiesForCreate;
import com.azure.resourcemanager.postgresql.models.ServerPropertiesForDefaultCreate;
import com.azure.resourcemanager.postgresql.models.ServerVersion;
import com.azure.resourcemanager.postgresql.models.Sku;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.database.DatabaseServerConfig;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlServer;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlServerModule;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlServiceSubscription;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class PostgreSqlServerDraft
extends PostgreSqlServer
implements AzResource.Draft<PostgreSqlServer, Server> {
    @Nullable
    private final PostgreSqlServer origin;
    @Nullable
    private Config config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    PostgreSqlServerDraft(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull PostgreSqlServerModule module) {
        super(name, resourceGroupName, module);
        this.origin = null;
    }

    PostgreSqlServerDraft(@Nonnull PostgreSqlServer origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
        this.config = null;
    }

    public void setConfig(@Nonnull DatabaseServerConfig config) {
        this.setAdminName(config.getAdminName());
        this.setAdminPassword(config.getAdminPassword());
        this.setRegion(config.getRegion());
        this.setVersion(config.getVersion());
        this.setFullyQualifiedDomainName(config.getFullyQualifiedDomainName());
        this.setAzureServiceAccessAllowed(config.isAzureServiceAccessAllowed());
        this.setLocalMachineAccessAllowed(config.isLocalMachineAccessAllowed());
    }

    private int getTierPriority(@Nonnull PerformanceTierProperties tier) {
        return StringUtils.equals((CharSequence)"Basic", (CharSequence)tier.id()) ? 1 : (StringUtils.equals((CharSequence)"GeneralPurpose", (CharSequence)tier.id()) ? 2 : (StringUtils.equals((CharSequence)"MemoryOptimized", (CharSequence)tier.id()) ? 3 : 4));
    }

    @Nullable
    private ServerVersion validateServerVersion(String version) {
        if (StringUtils.isNotBlank((CharSequence)version)) {
            ServerVersion res = ServerVersion.fromString((String)version);
            if (res == null) {
                throw new AzureToolkitRuntimeException(String.format("Invalid postgre version '%s'.", version));
            }
            return res;
        }
        return null;
    }

    @Nonnull
    @AzureOperation(name="azure/postgre.create_server.server", params={"this.getName()"})
    public Server createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            assert (this.config != null);
            PostgreSqlManager manager = Objects.requireNonNull((PostgreSqlManager)((PostgreSqlServiceSubscription)this.getParent()).getRemote(new boolean[0]));
            ServerPropertiesForDefaultCreate parameters = new ServerPropertiesForDefaultCreate().withAdministratorLogin(this.getAdminName()).withAdministratorLoginPassword(this.getAdminPassword()).withVersion(this.validateServerVersion(this.getVersion()));
            List tiers = manager.locationBasedPerformanceTiers().list(this.getRegion().getName()).stream().collect(Collectors.toList());
            PerformanceTierProperties tier = tiers.stream().filter(e -> CollectionUtils.isNotEmpty((Collection)e.serviceLevelObjectives())).min(Comparator.comparingInt(this::getTierPriority)).orElseThrow(() -> new AzureToolkitRuntimeException("PostgreSQL is not available in this location for your subscription."));
            Sku sku = new Sku().withName(((PerformanceTierServiceLevelObjectives)tier.serviceLevelObjectives().get(0)).id());
            Server.DefinitionStages.WithCreate create = manager.servers().define(this.getName()).withRegion(this.getRegion().getName()).withExistingResourceGroup(this.getResourceGroupName()).withProperties((ServerPropertiesForCreate)parameters).withSku(sku);
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(AzureString.format((String)"Start creating PostgreSQL server ({0})...", (Object[])new Object[]{this.getName()}));
            Server remote = (Server)this.doModify(() -> create.create(), "Creating");
            messager.success(AzureString.format((String)"PostgreSQL server({0}) is successfully created.", (Object[])new Object[]{this.getName()}));
            Server server = this.updateResourceInAzure(Objects.requireNonNull(remote));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return server;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="azure/postgre.update_server.server", params={"this.getName()"})
    public Server updateResourceInAzure(@Nonnull Server origin) {
        Server server = origin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)server);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            if (this.isAzureServiceAccessAllowed() != super.isAzureServiceAccessAllowed() || this.isLocalMachineAccessAllowed() != super.isLocalMachineAccessAllowed()) {
                IAzureMessager messager = AzureMessager.getMessager();
                messager.info(AzureString.format((String)"Start updating firewall rules of PostgreSQL server ({0})...", (Object[])new Object[]{this.getName()}));
                this.firewallRules().toggleAzureServiceAccess(this.isAzureServiceAccessAllowed());
                this.firewallRules().toggleLocalMachineAccess(this.isLocalMachineAccessAllowed());
                messager.success(AzureString.format((String)"Firewall rules of PostgreSQL server({0}) is successfully updated.", (Object[])new Object[]{this.getName()}));
            }
            Server server2 = origin;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return server2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    private synchronized Config ensureConfig() {
        this.config = Optional.ofNullable(this.config).orElseGet(Config::new);
        return this.config;
    }

    @Override
    @Nullable
    public String getAdminName() {
        return Optional.ofNullable(this.config).map(Config::getAdminName).orElseGet(() -> super.getAdminName());
    }

    @Nullable
    public String getAdminPassword() {
        return Optional.ofNullable(this.config).map(Config::getAdminPassword).orElse(null);
    }

    @Override
    @Nullable
    public Region getRegion() {
        return Optional.ofNullable(this.config).map(Config::getRegion).orElseGet(() -> super.getRegion());
    }

    @Override
    @Nullable
    public String getVersion() {
        return Optional.ofNullable(this.config).map(Config::getVersion).orElseGet(() -> super.getVersion());
    }

    @Override
    @Nullable
    public String getFullyQualifiedDomainName() {
        return Optional.ofNullable(this.config).map(Config::getFullyQualifiedDomainName).orElseGet(() -> super.getFullyQualifiedDomainName());
    }

    @Override
    public boolean isLocalMachineAccessAllowed() {
        return Optional.ofNullable(this.config).map(Config::isLocalMachineAccessAllowed).orElseGet(() -> super.isLocalMachineAccessAllowed());
    }

    @Override
    public boolean isAzureServiceAccessAllowed() {
        return Optional.ofNullable(this.config).map(Config::isAzureServiceAccessAllowed).orElseGet(() -> super.isAzureServiceAccessAllowed());
    }

    public void setAdminName(String name) {
        this.ensureConfig().setAdminName(name);
    }

    public void setAdminPassword(String password) {
        this.ensureConfig().setAdminPassword(password);
    }

    public void setRegion(Region region) {
        this.ensureConfig().setRegion(region);
    }

    public void setVersion(String version) {
        this.ensureConfig().setVersion(version);
    }

    public void setFullyQualifiedDomainName(String name) {
        this.ensureConfig().setFullyQualifiedDomainName(name);
    }

    public void setLocalMachineAccessAllowed(boolean allowed) {
        this.ensureConfig().setLocalMachineAccessAllowed(allowed);
    }

    public void setAzureServiceAccessAllowed(boolean allowed) {
        this.ensureConfig().setAzureServiceAccessAllowed(allowed);
    }

    public boolean isModified() {
        boolean notModified = Objects.isNull(this.config) || Objects.equals(this.config.isLocalMachineAccessAllowed(), super.isLocalMachineAccessAllowed()) || Objects.equals(this.config.isAzureServiceAccessAllowed(), super.isAzureServiceAccessAllowed()) || Objects.isNull(this.config.getAdminPassword()) || Objects.isNull(this.config.getAdminName()) || Objects.equals(this.config.getAdminName(), super.getAdminName()) || Objects.isNull(this.config.getRegion()) || Objects.equals(this.config.getRegion(), super.getRegion()) || Objects.isNull(this.config.getVersion()) || Objects.equals(this.config.getVersion(), super.getVersion()) || Objects.isNull(this.config.getFullyQualifiedDomainName()) || Objects.equals(this.config.getFullyQualifiedDomainName(), super.getFullyQualifiedDomainName());
        return !notModified;
    }

    @Nullable
    public PostgreSqlServer getOrigin() {
        return this.origin;
    }

    static {
        PostgreSqlServerDraft.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PostgreSqlServerDraft.java", PostgreSqlServerDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.postgre.PostgreSqlServerDraft", "", "", "", "com.azure.resourcemanager.postgresql.models.Server"), 88);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.postgre.PostgreSqlServerDraft", "com.azure.resourcemanager.postgresql.models.Server", "origin", "", "com.azure.resourcemanager.postgresql.models.Server"), 118);
    }

    private static class Config {
        private String adminName;
        private String adminPassword;
        private Region region;
        private String version;
        private String fullyQualifiedDomainName;
        private boolean azureServiceAccessAllowed;
        private boolean localMachineAccessAllowed;

        public String getAdminName() {
            return this.adminName;
        }

        public String getAdminPassword() {
            return this.adminPassword;
        }

        public Region getRegion() {
            return this.region;
        }

        public String getVersion() {
            return this.version;
        }

        public String getFullyQualifiedDomainName() {
            return this.fullyQualifiedDomainName;
        }

        public boolean isAzureServiceAccessAllowed() {
            return this.azureServiceAccessAllowed;
        }

        public boolean isLocalMachineAccessAllowed() {
            return this.localMachineAccessAllowed;
        }

        public void setAdminName(String adminName) {
            this.adminName = adminName;
        }

        public void setAdminPassword(String adminPassword) {
            this.adminPassword = adminPassword;
        }

        public void setRegion(Region region) {
            this.region = region;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setFullyQualifiedDomainName(String fullyQualifiedDomainName) {
            this.fullyQualifiedDomainName = fullyQualifiedDomainName;
        }

        public void setAzureServiceAccessAllowed(boolean azureServiceAccessAllowed) {
            this.azureServiceAccessAllowed = azureServiceAccessAllowed;
        }

        public void setLocalMachineAccessAllowed(boolean localMachineAccessAllowed) {
            this.localMachineAccessAllowed = localMachineAccessAllowed;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAzureServiceAccessAllowed() != other.isAzureServiceAccessAllowed()) {
                return false;
            }
            if (this.isLocalMachineAccessAllowed() != other.isLocalMachineAccessAllowed()) {
                return false;
            }
            String this$adminName = this.getAdminName();
            String other$adminName = other.getAdminName();
            if (this$adminName == null ? other$adminName != null : !this$adminName.equals(other$adminName)) {
                return false;
            }
            String this$adminPassword = this.getAdminPassword();
            String other$adminPassword = other.getAdminPassword();
            if (this$adminPassword == null ? other$adminPassword != null : !this$adminPassword.equals(other$adminPassword)) {
                return false;
            }
            Region this$region = this.getRegion();
            Region other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$fullyQualifiedDomainName = this.getFullyQualifiedDomainName();
            String other$fullyQualifiedDomainName = other.getFullyQualifiedDomainName();
            return !(this$fullyQualifiedDomainName == null ? other$fullyQualifiedDomainName != null : !this$fullyQualifiedDomainName.equals(other$fullyQualifiedDomainName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAzureServiceAccessAllowed() ? 79 : 97);
            result = result * 59 + (this.isLocalMachineAccessAllowed() ? 79 : 97);
            String $adminName = this.getAdminName();
            result = result * 59 + ($adminName == null ? 43 : $adminName.hashCode());
            String $adminPassword = this.getAdminPassword();
            result = result * 59 + ($adminPassword == null ? 43 : $adminPassword.hashCode());
            Region $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $fullyQualifiedDomainName = this.getFullyQualifiedDomainName();
            result = result * 59 + ($fullyQualifiedDomainName == null ? 43 : $fullyQualifiedDomainName.hashCode());
            return result;
        }

        public String toString() {
            return "PostgreSqlServerDraft.Config(adminName=" + this.getAdminName() + ", adminPassword=" + this.getAdminPassword() + ", region=" + this.getRegion() + ", version=" + this.getVersion() + ", fullyQualifiedDomainName=" + this.getFullyQualifiedDomainName() + ", azureServiceAccessAllowed=" + this.isAzureServiceAccessAllowed() + ", localMachineAccessAllowed=" + this.isLocalMachineAccessAllowed() + ")";
        }
    }
}

