/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.postgre;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.ExpandableStringEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerVersion;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzService;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlServer;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlServerModule;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlServiceSubscription;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzurePostgreSql
extends AbstractAzService<PostgreSqlServiceSubscription, PostgreSqlManager> {
    private static final Logger log = LoggerFactory.getLogger(AzurePostgreSql.class);

    public AzurePostgreSql() {
        super("Microsoft.DBforPostgreSQL");
    }

    @Nonnull
    public PostgreSqlServerModule servers(@Nonnull String subscriptionId) {
        PostgreSqlServiceSubscription rm = (PostgreSqlServiceSubscription)this.get(subscriptionId, null);
        assert (rm != null);
        return rm.getServerModule();
    }

    @Nonnull
    public List<PostgreSqlServer> servers() {
        return this.list().stream().flatMap(m -> m.servers().list().stream()).collect(Collectors.toList());
    }

    @Nullable
    protected PostgreSqlManager loadResourceFromAzure(@Nonnull String subscriptionId, String resourceGroup) {
        Account account = ((AzureAccount)Azure.az(AzureAccount.class)).account();
        AzureConfiguration config = Azure.az().config();
        String userAgent = config.getUserAgent();
        HttpLogDetailLevel logLevel = Optional.ofNullable(config.getLogLevel()).map(HttpLogDetailLevel::valueOf).orElse(HttpLogDetailLevel.NONE);
        AzureProfile azureProfile = new AzureProfile(null, subscriptionId, account.getEnvironment());
        return PostgreSqlManager.configure().withHttpClient(AbstractAzServiceSubscription.getDefaultHttpClient()).withLogOptions(new HttpLogOptions().setLogLevel(logLevel)).withPolicy(AbstractAzServiceSubscription.getUserAgentPolicy((String)userAgent)).authenticate(account.getTokenCredential(subscriptionId), azureProfile);
    }

    @Nonnull
    protected PostgreSqlServiceSubscription newResource(@Nonnull PostgreSqlManager manager) {
        return new PostgreSqlServiceSubscription(manager, this);
    }

    @Nonnull
    public List<String> listSupportedVersions() {
        return ServerVersion.values().stream().map(ExpandableStringEnum::toString).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Azure Database for PostgreSQL servers";
    }

    public String getServiceNameForTelemetry() {
        return "postgre";
    }
}

