/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.postgre;

import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.models.FirewallRule;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlFirewallRule;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlFirewallRuleModule;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlServer;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlServiceSubscription;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class PostgreSqlFirewallRuleDraft
extends PostgreSqlFirewallRule
implements AzResource.Draft<PostgreSqlFirewallRule, FirewallRule> {
    @Nullable
    private final PostgreSqlFirewallRule origin;
    @Nullable
    private Config config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    PostgreSqlFirewallRuleDraft(@Nonnull String name, @Nonnull PostgreSqlFirewallRuleModule module) {
        super(name, module);
        this.origin = null;
    }

    PostgreSqlFirewallRuleDraft(@Nonnull PostgreSqlFirewallRule origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
        this.config = null;
    }

    @Nonnull
    @AzureOperation(name="azure/postgre.create_firewall_rule.rule", params={"this.getName()"})
    public FirewallRule createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            PostgreSqlServer server = (PostgreSqlServer)this.getParent();
            PostgreSqlManager manager = Objects.requireNonNull((PostgreSqlManager)((PostgreSqlServiceSubscription)server.getParent()).getRemote());
            FirewallRule.DefinitionStages.WithCreate withCreate = manager.firewallRules().define(this.getName()).withExistingFlexibleServer(this.getResourceGroupName(), server.getName()).withStartIpAddress(this.getStartIpAddress()).withEndIpAddress(this.getEndIpAddress());
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(AzureString.format((String)"Start creating firewall rule \"{0}\"...", (Object[])new Object[]{this.getName()}));
            FirewallRule rule = withCreate.create();
            messager.success(AzureString.format((String)"Firewall rule \"{0}\" is successfully created.", (Object[])new Object[]{this.getName()}));
            FirewallRule firewallRule = rule;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return firewallRule;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="azure/postgre.update_firewall_rule.rule", params={"this.getName()"})
    public FirewallRule updateResourceInAzure(@Nonnull FirewallRule origin) {
        FirewallRule firewallRule = origin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)firewallRule);
        try {
            FirewallRule firewallRule2;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Optional<String> modifiedStartIp = Optional.ofNullable(this.getStartIpAddress()).filter(n -> !Objects.equals(n, super.getStartIpAddress()));
            Optional<String> modifiedEndIp = Optional.ofNullable(this.getEndIpAddress()).filter(n -> !Objects.equals(n, super.getEndIpAddress()));
            if (modifiedStartIp.isPresent() || modifiedEndIp.isPresent()) {
                PostgreSqlServer server = (PostgreSqlServer)this.getParent();
                PostgreSqlManager manager = Objects.requireNonNull((PostgreSqlManager)((PostgreSqlServiceSubscription)server.getParent()).getRemote());
                FirewallRule.Update update = manager.firewallRules().get(this.getResourceGroupName(), server.getName(), this.getName()).update();
                modifiedStartIp.ifPresent(arg_0 -> ((FirewallRule.Update)update).withStartIpAddress(arg_0));
                modifiedEndIp.ifPresent(arg_0 -> ((FirewallRule.Update)update).withEndIpAddress(arg_0));
                IAzureMessager messager = AzureMessager.getMessager();
                messager.info(AzureString.format((String)"Start updating firewall rule \"{0}\"...", (Object[])new Object[]{this.getName()}));
                FirewallRule rule = update.apply();
                messager.success(AzureString.format((String)"Firewall rule \"{0}\" is successfully updated.", (Object[])new Object[]{this.getName()}));
                firewallRule2 = rule;
            } else {
                firewallRule2 = origin;
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return firewallRule2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    private synchronized Config ensureConfig() {
        this.config = Optional.ofNullable(this.config).orElseGet(Config::new);
        return this.config;
    }

    @Override
    @Nullable
    public String getStartIpAddress() {
        return Optional.ofNullable(this.config).map(Config::getStartIpAddress).orElseGet(() -> super.getStartIpAddress());
    }

    public void setStartIpAddress(String startIpAddress) {
        this.ensureConfig().setStartIpAddress(startIpAddress);
    }

    @Override
    @Nullable
    public String getEndIpAddress() {
        return Optional.ofNullable(this.config).map(Config::getEndIpAddress).orElseGet(() -> super.getEndIpAddress());
    }

    public void setEndIpAddress(String endIpAddress) {
        this.ensureConfig().setEndIpAddress(endIpAddress);
    }

    public boolean isModified() {
        boolean notModified = Objects.isNull(this.config) || Objects.isNull(this.config.getStartIpAddress()) || Objects.equals(this.config.getStartIpAddress(), super.getStartIpAddress()) || Objects.isNull(this.config.getEndIpAddress()) || Objects.equals(this.config.getEndIpAddress(), super.getEndIpAddress());
        return !notModified;
    }

    @Nullable
    public PostgreSqlFirewallRule getOrigin() {
        return this.origin;
    }

    static {
        PostgreSqlFirewallRuleDraft.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PostgreSqlFirewallRuleDraft.java", PostgreSqlFirewallRuleDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.postgre.PostgreSqlFirewallRuleDraft", "", "", "", "com.azure.resourcemanager.postgresqlflexibleserver.models.FirewallRule"), 49);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.postgre.PostgreSqlFirewallRuleDraft", "com.azure.resourcemanager.postgresqlflexibleserver.models.FirewallRule", "origin", "", "com.azure.resourcemanager.postgresqlflexibleserver.models.FirewallRule"), 66);
    }

    private static class Config {
        private String startIpAddress;
        private String endIpAddress;

        public String getStartIpAddress() {
            return this.startIpAddress;
        }

        public String getEndIpAddress() {
            return this.endIpAddress;
        }

        public void setStartIpAddress(String startIpAddress) {
            this.startIpAddress = startIpAddress;
        }

        public void setEndIpAddress(String endIpAddress) {
            this.endIpAddress = endIpAddress;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$startIpAddress = this.getStartIpAddress();
            String other$startIpAddress = other.getStartIpAddress();
            if (this$startIpAddress == null ? other$startIpAddress != null : !this$startIpAddress.equals(other$startIpAddress)) {
                return false;
            }
            String this$endIpAddress = this.getEndIpAddress();
            String other$endIpAddress = other.getEndIpAddress();
            return !(this$endIpAddress == null ? other$endIpAddress != null : !this$endIpAddress.equals(other$endIpAddress));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $startIpAddress = this.getStartIpAddress();
            result = result * 59 + ($startIpAddress == null ? 43 : $startIpAddress.hashCode());
            String $endIpAddress = this.getEndIpAddress();
            result = result * 59 + ($endIpAddress == null ? 43 : $endIpAddress.hashCode());
            return result;
        }

        public String toString() {
            return "PostgreSqlFirewallRuleDraft.Config(startIpAddress=" + this.getStartIpAddress() + ", endIpAddress=" + this.getEndIpAddress() + ")";
        }
    }
}

