/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.postgre;

import com.azure.core.util.ExpandableStringEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Server;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Sku;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Storage;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.model.Startable;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.utils.NetUtils;
import com.microsoft.azure.toolkit.lib.database.JdbcUrl;
import com.microsoft.azure.toolkit.lib.database.entity.IDatabaseServer;
import com.microsoft.azure.toolkit.lib.database.entity.IFirewallRule;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlDatabase;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlDatabaseModule;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlFirewallRuleModule;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlServerModule;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlServiceSubscription;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class PostgreSqlServer
extends AbstractAzResource<PostgreSqlServer, PostgreSqlServiceSubscription, Server>
implements Deletable,
Startable,
IDatabaseServer<PostgreSqlDatabase> {
    private final PostgreSqlDatabaseModule databaseModule;
    private final PostgreSqlFirewallRuleModule firewallRuleModule;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    protected PostgreSqlServer(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull PostgreSqlServerModule module) {
        super(name, resourceGroupName, (AbstractAzResourceModule)module);
        this.databaseModule = new PostgreSqlDatabaseModule(this);
        this.firewallRuleModule = new PostgreSqlFirewallRuleModule(this);
    }

    public PostgreSqlServer(@Nonnull PostgreSqlServer origin) {
        super((AbstractAzResource)origin);
        this.databaseModule = origin.databaseModule;
        this.firewallRuleModule = origin.firewallRuleModule;
    }

    protected PostgreSqlServer(@Nonnull Server remote, @Nonnull PostgreSqlServerModule module) {
        super(remote.name(), ResourceId.fromString((String)remote.id()).resourceGroupName(), (AbstractAzResourceModule)module);
        this.databaseModule = new PostgreSqlDatabaseModule(this);
        this.firewallRuleModule = new PostgreSqlFirewallRuleModule(this);
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Arrays.asList(new AbstractAzResourceModule[]{this.firewallRuleModule, this.databaseModule});
    }

    @Nonnull
    public PostgreSqlFirewallRuleModule firewallRules() {
        return this.firewallRuleModule;
    }

    @Nonnull
    public PostgreSqlDatabaseModule databases() {
        return this.databaseModule;
    }

    @Nonnull
    protected String loadStatus(@Nonnull Server remote) {
        return remote.state().toString();
    }

    public void start() {
        throw new AzureToolkitRuntimeException("not supported");
    }

    public void stop() {
        throw new AzureToolkitRuntimeException("not supported");
    }

    @AzureOperation(name="azure/postgre.restart_server.server", params={"this.getName()"})
    public void restart() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> Objects.requireNonNull((Server)this.getRemote()).restart(), "Restarting");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nullable
    public Region getRegion() {
        return this.remoteOptional().map(remote -> Region.fromName((String)remote.regionName())).orElse(null);
    }

    @Nullable
    public String getAdminName() {
        return this.remoteOptional().map(Server::administratorLogin).orElse(null);
    }

    @Nullable
    public String getFullAdminName() {
        return this.getAdminName();
    }

    @Nullable
    public String getFullyQualifiedDomainName() {
        return this.remoteOptional().map(Server::fullyQualifiedDomainName).orElse(null);
    }

    public boolean isAzureServiceAccessAllowed() {
        String ruleName = "AllowAllWindowsAzureIps";
        return this.firewallRules().exists("AllowAllWindowsAzureIps", this.getResourceGroupName());
    }

    public boolean isLocalMachineAccessAllowed() {
        String ruleName = IFirewallRule.getLocalMachineAccessRuleName();
        return this.firewallRules().exists(ruleName, this.getResourceGroupName());
    }

    @Nullable
    public String getVersion() {
        return this.remoteOptional().map(Server::version).map(ExpandableStringEnum::toString).orElse(null);
    }

    @Nullable
    public String getType() {
        return this.remoteOptional().map(Server::type).orElse(null);
    }

    @Nullable
    public String getSkuTier() {
        return this.remoteOptional().map(Server::sku).map(Sku::tier).map(ExpandableStringEnum::toString).orElse(null);
    }

    public int getStorageInMB() {
        return this.remoteOptional().map(Server::storage).map(Storage::storageSizeGB).map(s -> s * 1024).orElse(0);
    }

    @Nonnull
    public String getLocalMachinePublicIp() {
        String username = this.getAdminName() + "@" + this.getName();
        try {
            Class.forName("org.postgresql.Driver");
            DriverManager.getConnection(JdbcUrl.postgre((String)this.getFullyQualifiedDomainName(), (String)"postgres").toString(), username, null);
        }
        catch (SQLException e) {
            String ip = NetUtils.parseIpAddressFromMessage((String)e.getMessage());
            if (StringUtils.isNotBlank((CharSequence)ip)) {
                return ip;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return NetUtils.getPublicIp();
    }

    @Nonnull
    public JdbcUrl getJdbcUrl() {
        return JdbcUrl.postgre((String)this.getFullyQualifiedDomainName(), (String)"postgres");
    }

    @Nonnull
    public List<PostgreSqlDatabase> listDatabases() {
        return this.databases().list();
    }

    public boolean isStoppable() {
        return StringUtils.equalsIgnoreCase((CharSequence)this.getStatus(), (CharSequence)"Ready");
    }

    static {
        PostgreSqlServer.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PostgreSqlServer.java", PostgreSqlServer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "restart", "com.microsoft.azure.toolkit.lib.postgre.PostgreSqlServer", "", "", "", "void"), 95);
    }
}

