/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.postgre;

import com.azure.core.util.paging.ContinuablePage;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Database;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Databases;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.page.ItemPage;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlDatabase;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlServer;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlServiceSubscription;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class PostgreSqlDatabaseModule
extends AbstractAzResourceModule<PostgreSqlDatabase, PostgreSqlServer, Database> {
    public static final String NAME = "databases";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public PostgreSqlDatabaseModule(@Nonnull PostgreSqlServer parent) {
        super(NAME, (AzResource)parent);
    }

    @Nonnull
    protected PostgreSqlDatabase newResource(@Nonnull Database database) {
        return new PostgreSqlDatabase(database, this);
    }

    @Nonnull
    protected PostgreSqlDatabase newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new PostgreSqlDatabase(name, this);
    }

    @Nonnull
    protected Iterator<? extends ContinuablePage<String, Database>> loadResourcePagesFromAzure() {
        PostgreSqlServer server = (PostgreSqlServer)this.getParent();
        return Optional.ofNullable(this.getClient()).map(c -> c.listByServer(server.getResourceGroupName(), server.getName()).streamByPage(PostgreSqlDatabaseModule.getPageSize()).map(p -> new ItemPage(p.getValue().stream().filter(d -> !"azure_maintenance".equals(d.name())))).iterator()).orElse(Collections.emptyIterator());
    }

    @Nullable
    @AzureOperation(name="azure/postgre.load_database.database", params={"name"})
    protected Database loadResourceFromAzure(@Nonnull String name, String resourceGroup) {
        String string = name;
        String string2 = resourceGroup;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            PostgreSqlServer p = (PostgreSqlServer)this.getParent();
            Database database = Optional.ofNullable(this.getClient()).map(c -> c.get(p.getResourceGroupName(), p.getName(), name)).orElse(null);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return database;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/postgre.delete_database.database", params={"nameFromResourceId(id)"})
    protected void deleteResourceFromAzure(@Nonnull String id) {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            PostgreSqlServer p = (PostgreSqlServer)this.getParent();
            ResourceId resourceId = ResourceId.fromString((String)id);
            String name = resourceId.name();
            Optional.ofNullable(this.getClient()).ifPresent(c -> c.delete(p.getResourceGroupName(), p.getName(), name));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nullable
    protected Databases getClient() {
        return Optional.ofNullable(((PostgreSqlServiceSubscription)((PostgreSqlServer)this.getParent()).getParent()).getRemote()).map(PostgreSqlManager::databases).orElse(null);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "PostgreSQL database";
    }

    static {
        PostgreSqlDatabaseModule.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PostgreSqlDatabaseModule.java", PostgreSqlDatabaseModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "loadResourceFromAzure", "com.microsoft.azure.toolkit.lib.postgre.PostgreSqlDatabaseModule", "java.lang.String:java.lang.String", "name:resourceGroup", "", "com.azure.resourcemanager.postgresqlflexibleserver.models.Database"), 62);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "deleteResourceFromAzure", "com.microsoft.azure.toolkit.lib.postgre.PostgreSqlDatabaseModule", "java.lang.String", "id", "", "void"), 69);
    }
}

