/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.postgre;

import com.azure.core.util.ExpandableStringEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CheckNameAvailabilityRequest;
import com.azure.resourcemanager.postgresqlflexibleserver.models.NameAvailability;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.model.Availability;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.postgre.AzurePostgreSql;
import com.microsoft.azure.toolkit.lib.postgre.PostgreSqlServerModule;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;

public class PostgreSqlServiceSubscription
extends AbstractAzServiceSubscription<PostgreSqlServiceSubscription, PostgreSqlManager> {
    @Nonnull
    private final String subscriptionId;
    @Nonnull
    private final PostgreSqlServerModule serverModule;

    PostgreSqlServiceSubscription(@Nonnull String subscriptionId, @Nonnull AzurePostgreSql service) {
        super(subscriptionId, (AbstractAzResourceModule)service);
        this.subscriptionId = subscriptionId;
        this.serverModule = new PostgreSqlServerModule(this);
    }

    PostgreSqlServiceSubscription(@Nonnull PostgreSqlManager manager, @Nonnull AzurePostgreSql service) {
        this(manager.serviceClient().getSubscriptionId(), service);
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.serverModule);
    }

    @Nonnull
    public PostgreSqlServerModule servers() {
        return this.serverModule;
    }

    @Nonnull
    public List<Region> listSupportedRegions() {
        return super.listSupportedRegions(this.serverModule.getName());
    }

    @Nonnull
    public Availability checkNameAvailability(@Nonnull String location, @Nonnull String name) {
        CheckNameAvailabilityRequest request = new CheckNameAvailabilityRequest().withName(name).withType("Microsoft.DBforPostgreSQL/flexibleServers");
        NameAvailability result = ((PostgreSqlManager)Objects.requireNonNull(this.getRemote())).checkNameAvailabilityWithLocations().execute(location, request);
        return new Availability(result.nameAvailable().booleanValue(), Optional.ofNullable(result.reason()).map(ExpandableStringEnum::toString).orElse(""), result.message());
    }

    public boolean checkRegionAvailability(@Nonnull Region region) {
        return ((PostgreSqlManager)Objects.requireNonNull(this.getRemote())).locationBasedCapabilities().execute(region.getName()).stream().anyMatch(e -> CollectionUtils.isNotEmpty((Collection)e.supportedFlexibleServerEditions()));
    }

    @Nonnull
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Nonnull
    public PostgreSqlServerModule getServerModule() {
        return this.serverModule;
    }
}

