/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.postgre.single;

import com.azure.resourcemanager.postgresql.PostgreSqlManager;
import com.azure.resourcemanager.postgresql.models.NameAvailability;
import com.azure.resourcemanager.postgresql.models.NameAvailabilityRequest;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.model.Availability;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.postgre.single.AzurePostgreSql;
import com.microsoft.azure.toolkit.lib.postgre.single.PostgreSqlServerModule;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;

public class PostgreSqlServiceSubscription
extends AbstractAzServiceSubscription<PostgreSqlServiceSubscription, PostgreSqlManager> {
    @Nonnull
    private final String subscriptionId;
    @Nonnull
    private final PostgreSqlServerModule serverModule;

    PostgreSqlServiceSubscription(@Nonnull String subscriptionId, @Nonnull AzurePostgreSql service) {
        super(subscriptionId, (AbstractAzResourceModule)service);
        this.subscriptionId = subscriptionId;
        this.serverModule = new PostgreSqlServerModule(this);
    }

    PostgreSqlServiceSubscription(@Nonnull PostgreSqlManager manager, @Nonnull AzurePostgreSql service) {
        this(manager.serviceClient().getSubscriptionId(), service);
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.serverModule);
    }

    @Nonnull
    public PostgreSqlServerModule servers() {
        return this.serverModule;
    }

    @Nonnull
    public List<Region> listSupportedRegions() {
        return super.listSupportedRegions(this.serverModule.getName());
    }

    @Nonnull
    public Availability checkNameAvailability(@Nonnull String name) {
        NameAvailabilityRequest request = new NameAvailabilityRequest().withName(name).withType(((AzResource.None)this.getParent()).getName());
        NameAvailability result = ((PostgreSqlManager)Objects.requireNonNull(this.getRemote())).checkNameAvailabilities().execute(request);
        return new Availability(result.nameAvailable().booleanValue(), result.reason(), result.message());
    }

    public boolean checkRegionAvailability(@Nonnull Region region) {
        List tiers = ((PostgreSqlManager)Objects.requireNonNull(this.getRemote())).locationBasedPerformanceTiers().list(region.getName()).stream().collect(Collectors.toList());
        return tiers.stream().anyMatch(e -> CollectionUtils.isNotEmpty((Collection)e.serviceLevelObjectives()));
    }

    @Nonnull
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Nonnull
    public PostgreSqlServerModule getServerModule() {
        return this.serverModule;
    }
}

