/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.azure.resourcemanager.resources.ResourceManager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceManager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.resource.AzureResources;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupModule;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ResourceGroupManager
extends AbstractAzResourceManager<ResourceGroupManager, ResourceManager> {
    @Nonnull
    private final String subscriptionId;
    private final ResourceGroupModule groupModule;

    ResourceGroupManager(@Nonnull String subscriptionId, AzureResources service) {
        super(subscriptionId, (AbstractAzResourceModule)service);
        this.subscriptionId = subscriptionId;
        this.groupModule = new ResourceGroupModule(this);
    }

    ResourceGroupManager(@Nonnull ResourceManager remote, AzureResources service) {
        this(remote.subscriptionId(), service);
    }

    public List<AzResourceModule<?, ResourceGroupManager, ?>> getSubModules() {
        return Collections.singletonList(this.groupModule);
    }

    public ResourceGroupModule resourceGroups() {
        return this.groupModule;
    }

    public List<Region> listSupportedRegions() {
        return super.listSupportedRegions(this.groupModule.getName());
    }

    @Nonnull
    public String getId() {
        return String.format("/subscriptions/%s/resourceGroups", this.subscriptionId);
    }

    public ResourceManager getResourceManager() {
        return Objects.requireNonNull((ResourceManager)this.getRemote()).resourceManager();
    }

    @Nonnull
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public ResourceGroupModule getGroupModule() {
        return this.groupModule;
    }
}

