/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetry;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupManager;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupModule;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ResourceGroupDraft
extends ResourceGroup
implements AzResource.Draft<ResourceGroup, com.azure.resourcemanager.resources.models.ResourceGroup> {
    private static final String CREATE_NEW_RESOURCE_GROUP_KEY = "createNewResourceGroup";
    @Nullable
    private final ResourceGroup origin;
    @Nullable
    private Config config;

    ResourceGroupDraft(@Nonnull String name, String resourceGroupName, @Nonnull ResourceGroupModule module) {
        super(name, resourceGroupName, module);
        this.origin = null;
    }

    ResourceGroupDraft(@Nonnull ResourceGroup origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
        this.config = null;
    }

    @AzureOperation(name="resource.create_resource.resource|type", params={"this.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    public com.azure.resourcemanager.resources.models.ResourceGroup createResourceInAzure() {
        AzureTelemetry.getActionContext().setProperty(CREATE_NEW_RESOURCE_GROUP_KEY, String.valueOf(true));
        AzureTelemetry.getContext().setProperty("resourceType", this.getFullResourceType());
        AzureTelemetry.getContext().setProperty("subscriptionId", this.getSubscriptionId());
        String name = this.getName();
        Region region = this.getRegion();
        if (Objects.isNull(region)) {
            throw new AzureToolkitRuntimeException("'region' is required to create resource group.");
        }
        ResourceManager manager = Objects.requireNonNull((ResourceManager)((ResourceGroupManager)this.getParent()).getRemote());
        IAzureMessager messager = AzureMessager.getMessager();
        messager.info(AzureString.format((String)"Start creating Resource Group({0}) in region ({1})...", (Object[])new Object[]{name, region.getLabel()}));
        com.azure.resourcemanager.resources.models.ResourceGroup group = (com.azure.resourcemanager.resources.models.ResourceGroup)((ResourceGroup.DefinitionStages.WithCreate)((ResourceGroup.DefinitionStages.Blank)manager.resourceGroups().define(name)).withRegion(region.getName())).create();
        messager.success(AzureString.format((String)"Resource Group({0}) is successfully created.", (Object[])new Object[]{name}));
        return group;
    }

    @AzureOperation(name="resource.update_resource.resource|type", params={"this.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    public com.azure.resourcemanager.resources.models.ResourceGroup updateResourceInAzure(@Nonnull com.azure.resourcemanager.resources.models.ResourceGroup origin) {
        throw new AzureToolkitRuntimeException("not supported");
    }

    private synchronized Config ensureConfig() {
        this.config = Optional.ofNullable(this.config).orElseGet(Config::new);
        return this.config;
    }

    public void setRegion(@Nonnull Region region) {
        this.ensureConfig().setRegion(region);
    }

    @Override
    @Nullable
    public Region getRegion() {
        return Objects.requireNonNull(Optional.ofNullable(this.config).map(Config::getRegion).orElseGet(() -> super.getRegion()));
    }

    public boolean isModified() {
        boolean notModified = Objects.isNull(this.config) || Objects.isNull(this.config.getRegion()) || Objects.equals(this.config.getRegion(), super.getRegion());
        return !notModified;
    }

    @Nullable
    public ResourceGroup getOrigin() {
        return this.origin;
    }

    private static class Config {
        private Region region;

        public Region getRegion() {
            return this.region;
        }

        public void setRegion(Region region) {
            this.region = region;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Region this$region = this.getRegion();
            Region other$region = other.getRegion();
            return !(this$region == null ? other$region != null : !this$region.equals(other$region));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Region $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceGroupDraft.Config(region=" + this.getRegion() + ")";
        }
    }
}

