/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.models.Deployment;
import com.azure.resourcemanager.resources.models.Deployments;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.resource.ResourceDeployment;
import com.microsoft.azure.toolkit.lib.resource.ResourceDeploymentDraft;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupManager;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ResourceDeploymentModule
extends AbstractAzResourceModule<ResourceDeployment, ResourceGroup, Deployment> {
    public static final String NAME = "deployments";

    public ResourceDeploymentModule(@Nonnull ResourceGroup parent) {
        super(NAME, (AbstractAzResource)parent);
    }

    @Nullable
    public Deployments getClient() {
        return Optional.ofNullable((ResourceManager)((ResourceGroupManager)((ResourceGroup)this.parent).getParent()).getRemote()).map(ResourceManager::deployments).orElse(null);
    }

    @Nonnull
    @AzureOperation(name="resource.draft_for_create.resource|type", params={"name", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected ResourceDeploymentDraft newDraftForCreate(@Nonnull String name, @Nullable String resourceGroupName) {
        assert (resourceGroupName != null) : "'Resource group' is required.";
        return new ResourceDeploymentDraft(name, resourceGroupName, this);
    }

    @Nonnull
    @AzureOperation(name="resource.draft_for_update.resource|type", params={"origin.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected ResourceDeploymentDraft newDraftForUpdate(@Nonnull ResourceDeployment origin) {
        return new ResourceDeploymentDraft(origin);
    }

    @Nonnull
    @AzureOperation(name="resource.list_resources.type", params={"this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected Stream<Deployment> loadResourcesFromAzure() {
        ResourceManager manager = Objects.requireNonNull((ResourceManager)((ResourceGroupManager)((ResourceGroup)this.parent).getParent()).getRemote());
        return manager.deployments().listByResourceGroup(((ResourceGroup)this.parent).getName()).stream();
    }

    @Nonnull
    public String toResourceId(@Nonnull String resourceName, @Nullable String resourceGroup) {
        resourceGroup = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{resourceGroup, ((ResourceGroup)this.getParent()).getResourceGroupName(), "${rg}"});
        return String.format("/subscriptions/%s/resourceGroups/%s/providers/Microsoft.Resources/%s/%s", this.getSubscriptionId(), ((ResourceGroup)this.parent).getResourceGroupName(), this.getName(), resourceName).replace("${rg}", resourceGroup);
    }

    @Nonnull
    protected ResourceDeployment newResource(@Nonnull Deployment r) {
        return new ResourceDeployment(r, this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Resource deployment";
    }
}

