/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.servicelinker;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluentcore.policy.ProviderRegistrationPolicy;
import com.azure.resourcemanager.resources.models.Providers;
import com.azure.resourcemanager.servicelinker.ServiceLinkerManager;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.servicelinker.ServiceLinker;
import com.microsoft.azure.toolkit.lib.servicelinker.ServiceLinkerModule;
import java.util.List;
import java.util.Optional;

public interface ServiceLinkerConsumer
extends AzResource {
    public ServiceLinkerModule getServiceLinkerModule();

    default public List<ServiceLinker> getServiceLinkers() {
        return this.getServiceLinkerModule().list();
    }

    default public ServiceLinkerManager getLinkerManager() {
        String subscriptionId = this.getSubscriptionId();
        Account account = ((AzureAccount)Azure.az(AzureAccount.class)).account();
        String tenantId = account.getSubscription(subscriptionId).getTenantId();
        AzureConfiguration config = Azure.az().config();
        String userAgent = config.getUserAgent();
        HttpLogOptions logOptions = new HttpLogOptions();
        logOptions.setLogLevel(Optional.ofNullable(config.getLogLevel()).map(HttpLogDetailLevel::valueOf).orElse(HttpLogDetailLevel.NONE));
        AzureProfile azureProfile = new AzureProfile(tenantId, subscriptionId, account.getEnvironment());
        Providers providers = ((ResourceManager.Configurable)((ResourceManager.Configurable)ResourceManager.configure().withHttpClient(AbstractAzServiceSubscription.getDefaultHttpClient())).withPolicy(AbstractAzServiceSubscription.getUserAgentPolicy((String)userAgent))).authenticate(account.getTokenCredential(subscriptionId), azureProfile).withSubscription(subscriptionId).providers();
        return ServiceLinkerManager.configure().withHttpClient(AbstractAzServiceSubscription.getDefaultHttpClient()).withLogOptions(logOptions).withPolicy(AbstractAzServiceSubscription.getUserAgentPolicy((String)userAgent)).withPolicy((HttpPipelinePolicy)new ProviderRegistrationPolicy(providers)).authenticate(account.getTokenCredential(subscriptionId), azureProfile);
    }
}

