/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.azure.resourcemanager.appplatform.models.SpringService;
import com.azure.resourcemanager.appplatform.models.SpringServices;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudServiceSubscription;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SpringCloudClusterModule
extends AbstractAzResourceModule<SpringCloudCluster, SpringCloudServiceSubscription, SpringService> {
    public static final String NAME = "Spring";

    public SpringCloudClusterModule(@Nonnull SpringCloudServiceSubscription parent) {
        super(NAME, (AbstractAzResource)parent);
    }

    @Nullable
    public SpringServices getClient() {
        return Optional.ofNullable((AppPlatformManager)((SpringCloudServiceSubscription)this.parent).getRemote()).map(AppPlatformManager::springServices).orElse(null);
    }

    @Nonnull
    protected SpringCloudCluster newResource(@Nonnull SpringService r) {
        return new SpringCloudCluster(r, this);
    }

    @Nonnull
    protected SpringCloudCluster newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new SpringCloudCluster(name, Objects.requireNonNull(resourceGroupName), this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Spring Apps";
    }
}

