/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.resourcemanager.appplatform.implementation.SpringAppDeploymentImpl;
import com.azure.resourcemanager.appplatform.models.RuntimeVersion;
import com.azure.resourcemanager.appplatform.models.SpringApp;
import com.azure.resourcemanager.appplatform.models.SpringAppDeployment;
import com.azure.resourcemanager.appplatform.models.UserSourceType;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.IArtifact;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentModule;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudDeploymentConfig;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringCloudDeploymentDraft
extends SpringCloudDeployment
implements AzResource.Draft<SpringCloudDeployment, SpringAppDeployment>,
InvocationHandler {
    private static final Logger log;
    private static final String DEFAULT_RUNTIME_VERSION = "Java_8";
    private static final String RUNTIME_VERSION_PATTERN = "[Jj]ava((\\s)?|_)(8|11)$";
    @Nonnull
    private final IConfig configProxy;
    @Nullable
    private final SpringCloudDeployment origin;
    @Nullable
    private Config config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    protected SpringCloudDeploymentDraft(@Nonnull String name, @Nonnull SpringCloudDeploymentModule module) {
        super(name, module);
        this.origin = null;
        this.configProxy = (IConfig)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IConfig.class}, (InvocationHandler)this);
    }

    protected SpringCloudDeploymentDraft(@Nonnull SpringCloudDeployment origin) {
        super(origin);
        this.origin = origin;
        this.configProxy = (IConfig)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IConfig.class}, (InvocationHandler)this);
    }

    public void setConfig(@Nonnull SpringCloudDeploymentConfig deploymentConfig) {
        this.setCpu(deploymentConfig.getCpu());
        this.setMemoryInGB(deploymentConfig.getMemoryInGB());
        this.setInstanceNum(deploymentConfig.getInstanceCount());
        this.setEnvironmentVariables(deploymentConfig.getEnvironment());
        this.setRuntimeVersion(deploymentConfig.getRuntimeVersion());
        this.setJvmOptions(deploymentConfig.getJvmOptions());
        this.setArtifact(deploymentConfig.getArtifact());
    }

    @Nonnull
    public SpringCloudDeploymentConfig getConfig() {
        return SpringCloudDeploymentConfig.builder().deploymentName(this.getName()).cpu(this.getCpu()).memoryInGB(this.getMemoryInGB()).instanceCount(this.getInstanceNum()).jvmOptions(this.getJvmOptions()).runtimeVersion(this.getRuntimeVersion()).environment(this.getEnvironmentVariables()).artifact(this.getArtifact()).build();
    }

    public void reset() {
        this.config = null;
    }

    @Nonnull
    @AzureOperation(name="resource.create_resource.resource|type", params={"this.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    public SpringAppDeployment createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            String name = this.getName();
            SpringApp app = Objects.requireNonNull((SpringApp)((SpringCloudApp)this.getParent()).getRemote());
            SpringAppDeploymentImpl create = (SpringAppDeploymentImpl)app.deployments().define(name);
            create.withExistingSource(UserSourceType.JAR, "<default>");
            this.modify(create);
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(AzureString.format((String)"Start creating deployment({0})...", (Object[])new Object[]{name}));
            SpringAppDeployment deployment = (SpringAppDeployment)this.doModify(() -> (SpringAppDeployment)create.create(), "Creating");
            messager.success(AzureString.format((String)"Deployment({0}) is successfully created", (Object[])new Object[]{name}));
            SpringAppDeployment springAppDeployment = deployment = this.scaleDeploymentInAzure(deployment);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return springAppDeployment;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="resource.update_resource.resource|type", params={"this.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    public SpringAppDeployment updateResourceInAzure(@Nonnull SpringAppDeployment deployment) {
        SpringAppDeployment springAppDeployment = deployment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)springAppDeployment);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            SpringAppDeploymentImpl update = (SpringAppDeploymentImpl)Objects.requireNonNull(deployment).update();
            if (this.modify(update)) {
                IAzureMessager messager = AzureMessager.getMessager();
                messager.info(AzureString.format((String)"Start updating deployment({0})...", (Object[])new Object[]{deployment.name()}));
                deployment = (SpringAppDeployment)update.apply();
                messager.success(AzureString.format((String)"Deployment({0}) is successfully updated", (Object[])new Object[]{deployment.name()}));
            }
            SpringAppDeployment springAppDeployment2 = deployment = this.scaleDeploymentInAzure(deployment);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return springAppDeployment2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="springcloud.scale_deployment.deployment", params={"this.getName()"}, type=AzureOperation.Type.SERVICE)
    SpringAppDeployment scaleDeploymentInAzure(@Nonnull SpringAppDeployment deployment) {
        SpringAppDeployment springAppDeployment = deployment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)springAppDeployment);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            SpringAppDeployment.Update update = (SpringAppDeployment.Update)deployment.update();
            boolean modified = this.scale(deployment, update);
            if (modified) {
                IAzureMessager messager = AzureMessager.getMessager();
                this.doModify(() -> {
                    messager.info(AzureString.format((String)"Start scaling deployment({0})...", (Object[])new Object[]{deployment.name()}));
                    update.apply();
                    messager.success(AzureString.format((String)"Deployment({0}) is successfully scaled.", (Object[])new Object[]{deployment.name()}));
                }, "Scaling");
            }
            SpringAppDeployment springAppDeployment2 = deployment;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return springAppDeployment2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    boolean modify(@Nonnull SpringAppDeploymentImpl deployment) {
        boolean modified;
        Map<String, String> newEnv = this.getEnvironmentVariables();
        String newJvmOptions = this.getJvmOptions();
        String newVersion = this.getRuntimeVersion();
        File newArtifact = Optional.ofNullable(this.config.artifact).map(IArtifact::getFile).orElse(null);
        Map<String, String> oldEnv = super.getEnvironmentVariables();
        boolean bl = modified = !Objects.equals(newEnv, oldEnv) && Objects.nonNull(newEnv) || !Objects.equals(newJvmOptions, super.getJvmOptions()) && Objects.nonNull(newJvmOptions) || !Objects.equals(newVersion, super.getRuntimeVersion()) && Objects.nonNull(newVersion) || Objects.nonNull(newArtifact);
        if (modified) {
            if (Objects.nonNull(newEnv)) {
                Optional.ofNullable(oldEnv).ifPresent(e -> new HashSet(e.keySet()).forEach(arg_0 -> ((SpringAppDeploymentImpl)deployment).withoutEnvironment(arg_0)));
                Optional.of(newEnv).ifPresent(e -> e.forEach((arg_0, arg_1) -> ((SpringAppDeploymentImpl)deployment).withEnvironment(arg_0, arg_1)));
            }
            Optional.ofNullable(newJvmOptions).ifPresent(arg_0 -> ((SpringAppDeploymentImpl)deployment).withJvmOptions(arg_0));
            Optional.ofNullable(newVersion).ifPresent(v -> deployment.withRuntime(RuntimeVersion.fromString((String)SpringCloudDeploymentDraft.formalizeRuntimeVersion(v))));
            Optional.ofNullable(newArtifact).ifPresent(arg_0 -> ((SpringAppDeploymentImpl)deployment).withJarFile(arg_0));
        }
        return modified;
    }

    private boolean scale(@Nonnull SpringAppDeployment deployment, @Nonnull SpringAppDeployment.Update update) {
        boolean scaled;
        Integer newCpu = this.getCpu();
        Integer newMemoryInGB = this.getMemoryInGB();
        Integer newInstanceNum = this.getInstanceNum();
        boolean bl = scaled = !Objects.equals(super.getCpu(), newCpu) && Objects.nonNull(newCpu) || !Objects.equals(super.getMemoryInGB(), newMemoryInGB) && Objects.nonNull(newMemoryInGB) || !Objects.equals(deployment.instances().size(), newInstanceNum) && Objects.nonNull(newInstanceNum);
        if (scaled) {
            Optional.ofNullable(newCpu).ifPresent(arg_0 -> ((SpringAppDeployment.Update)update).withCpu(arg_0));
            Optional.ofNullable(newMemoryInGB).ifPresent(arg_0 -> ((SpringAppDeployment.Update)update).withMemory(arg_0));
            Optional.ofNullable(newInstanceNum).ifPresent(arg_0 -> ((SpringAppDeployment.Update)update).withInstance(arg_0));
        }
        return scaled;
    }

    @Nonnull
    private static String formalizeRuntimeVersion(String runtimeVersion) {
        if (StringUtils.isEmpty((CharSequence)runtimeVersion)) {
            return DEFAULT_RUNTIME_VERSION;
        }
        String fixedRuntimeVersion = StringUtils.trim((String)runtimeVersion);
        Matcher matcher = Pattern.compile(RUNTIME_VERSION_PATTERN).matcher(fixedRuntimeVersion);
        if (matcher.matches()) {
            return Objects.equals(matcher.group(3), "8") ? DEFAULT_RUNTIME_VERSION : "Java_11";
        }
        log.warn("{} is not a valid runtime version, supported values are Java 8 and Java 11, using Java 8 in this deployment.", (Object)fixedRuntimeVersion);
        return DEFAULT_RUNTIME_VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public synchronized Object invoke(Object proxy, @Nonnull Method method, Object[] args) throws Throwable {
        args = (Object[])ObjectUtils.firstNonNull((Object[])new Object[][]{args, new Object[0]});
        if (method.getName().startsWith("set")) {
            SpringCloudDeploymentDraft springCloudDeploymentDraft = this;
            synchronized (springCloudDeploymentDraft) {
                this.config = (Config)ObjectUtils.firstNonNull((Object[])new Config[]{this.config, new Config()});
                return method.invoke((Object)this.config, args);
            }
        }
        Set<String> excludes = Collections.singleton("getArtifact");
        Object result = Objects.nonNull(this.config) ? method.invoke((Object)this.config, args) : null;
        return Objects.nonNull(result) || excludes.contains(method.getName()) ? result : this.invokeSuper(method, args);
    }

    private Object invokeSuper(@Nonnull Method method, @Nonnull Object[] args) throws Throwable {
        Class[] classes = (Class[])Arrays.stream(args).map(Object::getClass).toArray(value -> new Class[0]);
        MethodType type = MethodType.methodType(method.getReturnType(), classes);
        MethodHandle handle = MethodHandles.lookup().findSpecial(SpringCloudDeployment.class, method.getName(), type, this.getClass()).bindTo(this);
        return handle.invokeWithArguments(args);
    }

    public boolean isModified() {
        boolean notModified = Objects.isNull(this.config) || Objects.isNull(this.config.getArtifact()) || Objects.isNull(this.config.getEnvironmentVariables()) || Objects.equals(this.config.getEnvironmentVariables(), super.getEnvironmentVariables()) || Objects.isNull(this.config.getJvmOptions()) || Objects.equals(this.config.getJvmOptions(), super.getJvmOptions()) || Objects.isNull(this.config.getRuntimeVersion()) || Objects.equals(this.config.getRuntimeVersion(), super.getRuntimeVersion()) || Objects.isNull(this.config.getCpu()) || Objects.equals(this.config.getCpu(), super.getCpu()) || Objects.isNull(this.config.getMemoryInGB()) || Objects.equals(this.config.getMemoryInGB(), super.getMemoryInGB()) || Objects.isNull(this.config.getInstanceNum()) || Objects.equals(this.config.getInstanceNum(), super.getInstanceNum());
        return !notModified;
    }

    @Nullable
    public SpringCloudDeployment getOrigin() {
        return this.origin;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.configProxy.setEnvironmentVariables(environmentVariables);
    }

    public void setJvmOptions(String jvmOptions) {
        this.configProxy.setJvmOptions(jvmOptions);
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.configProxy.setRuntimeVersion(runtimeVersion);
    }

    public void setArtifact(IArtifact artifact) {
        this.configProxy.setArtifact(artifact);
    }

    public void setCpu(Integer cpu) {
        this.configProxy.setCpu(cpu);
    }

    public void setMemoryInGB(Integer memoryInGB) {
        this.configProxy.setMemoryInGB(memoryInGB);
    }

    public void setInstanceNum(Integer instanceNum) {
        this.configProxy.setInstanceNum(instanceNum);
    }

    @Override
    public Map<String, String> getEnvironmentVariables() {
        return this.configProxy.getEnvironmentVariables();
    }

    @Override
    public String getJvmOptions() {
        return this.configProxy.getJvmOptions();
    }

    @Override
    public String getRuntimeVersion() {
        return this.configProxy.getRuntimeVersion();
    }

    public IArtifact getArtifact() {
        return this.configProxy.getArtifact();
    }

    @Override
    public Integer getCpu() {
        return this.configProxy.getCpu();
    }

    @Override
    public Integer getMemoryInGB() {
        return this.configProxy.getMemoryInGB();
    }

    @Override
    public Integer getInstanceNum() {
        return this.configProxy.getInstanceNum();
    }

    static {
        SpringCloudDeploymentDraft.ajc$preClinit();
        log = LoggerFactory.getLogger(SpringCloudDeploymentDraft.class);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpringCloudDeploymentDraft.java", SpringCloudDeploymentDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentDraft", "", "", "", "com.azure.resourcemanager.appplatform.models.SpringAppDeployment"), 112);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentDraft", "com.azure.resourcemanager.appplatform.models.SpringAppDeployment", "deployment", "", "com.azure.resourcemanager.appplatform.models.SpringAppDeployment"), 133);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "scaleDeploymentInAzure", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentDraft", "com.azure.resourcemanager.appplatform.models.SpringAppDeployment", "deployment", "", "com.azure.resourcemanager.appplatform.models.SpringAppDeployment"), 147);
    }

    private static interface IConfig {
        public void setEnvironmentVariables(Map<String, String> var1);

        public void setJvmOptions(String var1);

        public void setRuntimeVersion(String var1);

        public void setArtifact(IArtifact var1);

        public void setCpu(Integer var1);

        public void setMemoryInGB(Integer var1);

        public void setInstanceNum(Integer var1);

        @Nullable
        public Map<String, String> getEnvironmentVariables();

        @Nullable
        public String getJvmOptions();

        @Nullable
        public String getRuntimeVersion();

        @Nullable
        public IArtifact getArtifact();

        @Nullable
        public Integer getCpu();

        @Nullable
        public Integer getMemoryInGB();

        @Nullable
        public Integer getInstanceNum();
    }

    private static class Config
    implements IConfig {
        @Nullable
        Map<String, String> environmentVariables;
        @Nullable
        String jvmOptions;
        @Nullable
        String runtimeVersion;
        @Nullable
        IArtifact artifact;
        @Nullable
        Integer cpu;
        @Nullable
        Integer memoryInGB;
        @Nullable
        Integer instanceNum;

        @Override
        @Nullable
        public Map<String, String> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        @Nullable
        public String getJvmOptions() {
            return this.jvmOptions;
        }

        @Override
        @Nullable
        public String getRuntimeVersion() {
            return this.runtimeVersion;
        }

        @Override
        @Nullable
        public IArtifact getArtifact() {
            return this.artifact;
        }

        @Override
        @Nullable
        public Integer getCpu() {
            return this.cpu;
        }

        @Override
        @Nullable
        public Integer getMemoryInGB() {
            return this.memoryInGB;
        }

        @Override
        @Nullable
        public Integer getInstanceNum() {
            return this.instanceNum;
        }

        @Override
        public void setEnvironmentVariables(@Nullable Map<String, String> environmentVariables) {
            this.environmentVariables = environmentVariables;
        }

        @Override
        public void setJvmOptions(@Nullable String jvmOptions) {
            this.jvmOptions = jvmOptions;
        }

        @Override
        public void setRuntimeVersion(@Nullable String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
        }

        @Override
        public void setArtifact(@Nullable IArtifact artifact) {
            this.artifact = artifact;
        }

        @Override
        public void setCpu(@Nullable Integer cpu) {
            this.cpu = cpu;
        }

        @Override
        public void setMemoryInGB(@Nullable Integer memoryInGB) {
            this.memoryInGB = memoryInGB;
        }

        @Override
        public void setInstanceNum(@Nullable Integer instanceNum) {
            this.instanceNum = instanceNum;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$cpu = this.getCpu();
            Integer other$cpu = other.getCpu();
            if (this$cpu == null ? other$cpu != null : !((Object)this$cpu).equals(other$cpu)) {
                return false;
            }
            Integer this$memoryInGB = this.getMemoryInGB();
            Integer other$memoryInGB = other.getMemoryInGB();
            if (this$memoryInGB == null ? other$memoryInGB != null : !((Object)this$memoryInGB).equals(other$memoryInGB)) {
                return false;
            }
            Integer this$instanceNum = this.getInstanceNum();
            Integer other$instanceNum = other.getInstanceNum();
            if (this$instanceNum == null ? other$instanceNum != null : !((Object)this$instanceNum).equals(other$instanceNum)) {
                return false;
            }
            Map<String, String> this$environmentVariables = this.getEnvironmentVariables();
            Map<String, String> other$environmentVariables = other.getEnvironmentVariables();
            if (this$environmentVariables == null ? other$environmentVariables != null : !((Object)this$environmentVariables).equals(other$environmentVariables)) {
                return false;
            }
            String this$jvmOptions = this.getJvmOptions();
            String other$jvmOptions = other.getJvmOptions();
            if (this$jvmOptions == null ? other$jvmOptions != null : !this$jvmOptions.equals(other$jvmOptions)) {
                return false;
            }
            String this$runtimeVersion = this.getRuntimeVersion();
            String other$runtimeVersion = other.getRuntimeVersion();
            if (this$runtimeVersion == null ? other$runtimeVersion != null : !this$runtimeVersion.equals(other$runtimeVersion)) {
                return false;
            }
            IArtifact this$artifact = this.getArtifact();
            IArtifact other$artifact = other.getArtifact();
            return !(this$artifact == null ? other$artifact != null : !this$artifact.equals(other$artifact));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $cpu = this.getCpu();
            result = result * 59 + ($cpu == null ? 43 : ((Object)$cpu).hashCode());
            Integer $memoryInGB = this.getMemoryInGB();
            result = result * 59 + ($memoryInGB == null ? 43 : ((Object)$memoryInGB).hashCode());
            Integer $instanceNum = this.getInstanceNum();
            result = result * 59 + ($instanceNum == null ? 43 : ((Object)$instanceNum).hashCode());
            Map<String, String> $environmentVariables = this.getEnvironmentVariables();
            result = result * 59 + ($environmentVariables == null ? 43 : ((Object)$environmentVariables).hashCode());
            String $jvmOptions = this.getJvmOptions();
            result = result * 59 + ($jvmOptions == null ? 43 : $jvmOptions.hashCode());
            String $runtimeVersion = this.getRuntimeVersion();
            result = result * 59 + ($runtimeVersion == null ? 43 : $runtimeVersion.hashCode());
            IArtifact $artifact = this.getArtifact();
            result = result * 59 + ($artifact == null ? 43 : $artifact.hashCode());
            return result;
        }

        public String toString() {
            return "SpringCloudDeploymentDraft.Config(environmentVariables=" + this.getEnvironmentVariables() + ", jvmOptions=" + this.getJvmOptions() + ", runtimeVersion=" + this.getRuntimeVersion() + ", artifact=" + this.getArtifact() + ", cpu=" + this.getCpu() + ", memoryInGB=" + this.getMemoryInGB() + ", instanceNum=" + this.getInstanceNum() + ")";
        }
    }
}

