/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.resourcemanager.appplatform.models.SpringApp;
import com.azure.resourcemanager.appplatform.models.SpringAppDeployment;
import com.azure.resourcemanager.appplatform.models.SpringAppDeployments;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentDraft;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class SpringCloudDeploymentModule
extends AbstractAzResourceModule<SpringCloudDeployment, SpringCloudApp, SpringAppDeployment> {
    public static final String NAME = "deployments";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public SpringCloudDeploymentModule(@Nonnull SpringCloudApp parent) {
        super(NAME, (AbstractAzResource)parent);
    }

    public SpringAppDeployments<?> getClient() {
        return Optional.ofNullable((SpringApp)((SpringCloudApp)this.parent).getRemote()).map(SpringApp::deployments).orElse(null);
    }

    @Nonnull
    @AzureOperation(name="resource.draft_for_create.resource|type", params={"name", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected SpringCloudDeploymentDraft newDraftForCreate(@Nonnull String name, @Nullable String resourceGroupName) {
        String string = name;
        String string2 = resourceGroupName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            SpringCloudDeploymentDraft springCloudDeploymentDraft = new SpringCloudDeploymentDraft(name, this);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return springCloudDeploymentDraft;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="resource.draft_for_update.resource|type", params={"origin.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected SpringCloudDeploymentDraft newDraftForUpdate(@Nonnull SpringCloudDeployment origin) {
        SpringCloudDeployment springCloudDeployment = origin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)((Object)springCloudDeployment));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            SpringCloudDeploymentDraft springCloudDeploymentDraft = new SpringCloudDeploymentDraft(origin);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return springCloudDeploymentDraft;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    protected SpringCloudDeployment newResource(@Nonnull SpringAppDeployment remote) {
        return new SpringCloudDeployment(remote, this);
    }

    @Nonnull
    protected SpringCloudDeployment newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new SpringCloudDeployment(name, this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Spring App deployment";
    }

    static {
        SpringCloudDeploymentModule.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpringCloudDeploymentModule.java", SpringCloudDeploymentModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "newDraftForCreate", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentModule", "java.lang.String:java.lang.String", "name:resourceGroupName", "", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentDraft"), 35);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "newDraftForUpdate", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentModule", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment", "origin", "", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentDraft"), 46);
    }
}

