/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.resourcemanager.appplatform.models.DeploymentInstance;
import com.azure.resourcemanager.appplatform.models.DeploymentResourceStatus;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import rx.Observable;
import rx.schedulers.Schedulers;

public class Utils {
    private static final int POLLING_INTERVAL = 1;
    protected static final List<String> DEPLOYMENT_PROCESSING_STATUS = Arrays.asList(DeploymentResourceStatus.COMPILING.toString(), DeploymentResourceStatus.ALLOCATING.toString(), DeploymentResourceStatus.UPGRADING.toString());

    public static boolean isDeploymentDone(@Nullable SpringCloudDeployment deployment) {
        if (deployment == null) {
            return false;
        }
        String deploymentResourceStatus = deployment.getStatus();
        if (DEPLOYMENT_PROCESSING_STATUS.contains(deploymentResourceStatus)) {
            return false;
        }
        String finalDiscoverStatus = BooleanUtils.isTrue((Boolean)deployment.isActive()) ? "UP" : "OUT_OF_SERVICE";
        List<DeploymentInstance> instanceList = deployment.getInstances();
        if (CollectionUtils.isEmpty(instanceList)) {
            return false;
        }
        boolean isInstanceDeployed = instanceList.stream().noneMatch(instance -> StringUtils.equalsIgnoreCase((CharSequence)instance.status(), (CharSequence)"waiting") || StringUtils.equalsIgnoreCase((CharSequence)instance.status(), (CharSequence)"pending"));
        boolean isInstanceDiscovered = instanceList.stream().allMatch(instance -> StringUtils.equalsIgnoreCase((CharSequence)instance.discoveryStatus(), (CharSequence)finalDiscoverStatus));
        return isInstanceDeployed && isInstanceDiscovered;
    }

    public static <T> T pollUntil(Callable<T> callable, @Nonnull Predicate<T> predicate, int timeOutInSeconds) {
        return Utils.pollUntil(callable, predicate, timeOutInSeconds, 1);
    }

    public static <T> T pollUntil(Callable<T> callable, @Nonnull Predicate<T> predicate, int timeOutInSeconds, int pollingInterval) {
        long timeout = System.currentTimeMillis() + (long)timeOutInSeconds * 1000L;
        return (T)Observable.interval((long)pollingInterval, (TimeUnit)TimeUnit.SECONDS).timeout((long)timeOutInSeconds, TimeUnit.SECONDS).flatMap(aLong -> Observable.fromCallable((Callable)callable)).subscribeOn(Schedulers.io()).takeUntil(resource -> predicate.test(resource) || System.currentTimeMillis() > timeout).toBlocking().last();
    }
}

