/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud.config;

import com.azure.resourcemanager.appplatform.models.RuntimeVersion;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudDeploymentConfig;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;

@Deprecated
public class SpringCloudAppConfig {
    private String subscriptionId;
    private String clusterName;
    private String appName;
    private String resourceGroup;
    private Boolean isPublic;
    private String runtimeVersion;
    @Nullable
    private String activeDeploymentName;
    private SpringCloudDeploymentConfig deployment;

    @Nonnull
    public Boolean isPublic() {
        return BooleanUtils.isTrue((Boolean)this.isPublic);
    }

    @Nonnull
    public static SpringCloudAppConfig fromApp(@Nonnull SpringCloudApp app) {
        SpringCloudDeployment deployment = Optional.ofNullable(app.getActiveDeployment()).orElse((SpringCloudDeployment)app.deployments().getOrDraft("default", app.getResourceGroupName()));
        SpringCloudDeploymentConfig deploymentConfig = SpringCloudDeploymentConfig.fromDeployment(deployment);
        SpringCloudAppConfig appConfig = SpringCloudAppConfig.builder().deployment(deploymentConfig).build();
        appConfig.setSubscriptionId(app.getSubscriptionId());
        appConfig.setResourceGroup(appConfig.getResourceGroup());
        appConfig.setClusterName(((SpringCloudCluster)app.getParent()).getName());
        appConfig.setAppName(app.getName());
        appConfig.setIsPublic(Objects.equals(app.isPublicEndpointEnabled(), true));
        return appConfig;
    }

    private static Boolean $default$isPublic() {
        return false;
    }

    private static String $default$runtimeVersion() {
        return RuntimeVersion.JAVA_8.toString();
    }

    public static SpringCloudAppConfigBuilder builder() {
        return new SpringCloudAppConfigBuilder();
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public Boolean getIsPublic() {
        return this.isPublic;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    @Nullable
    public String getActiveDeploymentName() {
        return this.activeDeploymentName;
    }

    public SpringCloudDeploymentConfig getDeployment() {
        return this.deployment;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
    }

    public void setIsPublic(Boolean isPublic) {
        this.isPublic = isPublic;
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
    }

    public void setActiveDeploymentName(@Nullable String activeDeploymentName) {
        this.activeDeploymentName = activeDeploymentName;
    }

    public void setDeployment(SpringCloudDeploymentConfig deployment) {
        this.deployment = deployment;
    }

    public SpringCloudAppConfig() {
        this.isPublic = SpringCloudAppConfig.$default$isPublic();
        this.runtimeVersion = SpringCloudAppConfig.$default$runtimeVersion();
    }

    public SpringCloudAppConfig(String subscriptionId, String clusterName, String appName, String resourceGroup, Boolean isPublic, String runtimeVersion, @Nullable String activeDeploymentName, SpringCloudDeploymentConfig deployment) {
        this.subscriptionId = subscriptionId;
        this.clusterName = clusterName;
        this.appName = appName;
        this.resourceGroup = resourceGroup;
        this.isPublic = isPublic;
        this.runtimeVersion = runtimeVersion;
        this.activeDeploymentName = activeDeploymentName;
        this.deployment = deployment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringCloudAppConfig)) {
            return false;
        }
        SpringCloudAppConfig other = (SpringCloudAppConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isPublic = this.getIsPublic();
        Boolean other$isPublic = other.getIsPublic();
        if (this$isPublic == null ? other$isPublic != null : !((Object)this$isPublic).equals(other$isPublic)) {
            return false;
        }
        String this$subscriptionId = this.getSubscriptionId();
        String other$subscriptionId = other.getSubscriptionId();
        if (this$subscriptionId == null ? other$subscriptionId != null : !this$subscriptionId.equals(other$subscriptionId)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        String this$resourceGroup = this.getResourceGroup();
        String other$resourceGroup = other.getResourceGroup();
        if (this$resourceGroup == null ? other$resourceGroup != null : !this$resourceGroup.equals(other$resourceGroup)) {
            return false;
        }
        String this$runtimeVersion = this.getRuntimeVersion();
        String other$runtimeVersion = other.getRuntimeVersion();
        if (this$runtimeVersion == null ? other$runtimeVersion != null : !this$runtimeVersion.equals(other$runtimeVersion)) {
            return false;
        }
        String this$activeDeploymentName = this.getActiveDeploymentName();
        String other$activeDeploymentName = other.getActiveDeploymentName();
        if (this$activeDeploymentName == null ? other$activeDeploymentName != null : !this$activeDeploymentName.equals(other$activeDeploymentName)) {
            return false;
        }
        SpringCloudDeploymentConfig this$deployment = this.getDeployment();
        SpringCloudDeploymentConfig other$deployment = other.getDeployment();
        return !(this$deployment == null ? other$deployment != null : !((Object)this$deployment).equals(other$deployment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpringCloudAppConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isPublic = this.getIsPublic();
        result = result * 59 + ($isPublic == null ? 43 : ((Object)$isPublic).hashCode());
        String $subscriptionId = this.getSubscriptionId();
        result = result * 59 + ($subscriptionId == null ? 43 : $subscriptionId.hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        String $resourceGroup = this.getResourceGroup();
        result = result * 59 + ($resourceGroup == null ? 43 : $resourceGroup.hashCode());
        String $runtimeVersion = this.getRuntimeVersion();
        result = result * 59 + ($runtimeVersion == null ? 43 : $runtimeVersion.hashCode());
        String $activeDeploymentName = this.getActiveDeploymentName();
        result = result * 59 + ($activeDeploymentName == null ? 43 : $activeDeploymentName.hashCode());
        SpringCloudDeploymentConfig $deployment = this.getDeployment();
        result = result * 59 + ($deployment == null ? 43 : ((Object)$deployment).hashCode());
        return result;
    }

    public static class SpringCloudAppConfigBuilder {
        private String subscriptionId;
        private String clusterName;
        private String appName;
        private String resourceGroup;
        private boolean isPublic$set;
        private Boolean isPublic$value;
        private boolean runtimeVersion$set;
        private String runtimeVersion$value;
        private String activeDeploymentName;
        private SpringCloudDeploymentConfig deployment;

        SpringCloudAppConfigBuilder() {
        }

        public SpringCloudAppConfigBuilder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public SpringCloudAppConfigBuilder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public SpringCloudAppConfigBuilder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public SpringCloudAppConfigBuilder resourceGroup(String resourceGroup) {
            this.resourceGroup = resourceGroup;
            return this;
        }

        public SpringCloudAppConfigBuilder isPublic(Boolean isPublic) {
            this.isPublic$value = isPublic;
            this.isPublic$set = true;
            return this;
        }

        public SpringCloudAppConfigBuilder runtimeVersion(String runtimeVersion) {
            this.runtimeVersion$value = runtimeVersion;
            this.runtimeVersion$set = true;
            return this;
        }

        public SpringCloudAppConfigBuilder activeDeploymentName(@Nullable String activeDeploymentName) {
            this.activeDeploymentName = activeDeploymentName;
            return this;
        }

        public SpringCloudAppConfigBuilder deployment(SpringCloudDeploymentConfig deployment) {
            this.deployment = deployment;
            return this;
        }

        public SpringCloudAppConfig build() {
            Boolean isPublic$value = this.isPublic$value;
            if (!this.isPublic$set) {
                isPublic$value = SpringCloudAppConfig.$default$isPublic();
            }
            String runtimeVersion$value = this.runtimeVersion$value;
            if (!this.runtimeVersion$set) {
                runtimeVersion$value = SpringCloudAppConfig.$default$runtimeVersion();
            }
            return new SpringCloudAppConfig(this.subscriptionId, this.clusterName, this.appName, this.resourceGroup, isPublic$value, runtimeVersion$value, this.activeDeploymentName, this.deployment);
        }

        public String toString() {
            return "SpringCloudAppConfig.SpringCloudAppConfigBuilder(subscriptionId=" + this.subscriptionId + ", clusterName=" + this.clusterName + ", appName=" + this.appName + ", resourceGroup=" + this.resourceGroup + ", isPublic$value=" + this.isPublic$value + ", runtimeVersion$value=" + this.runtimeVersion$value + ", activeDeploymentName=" + this.activeDeploymentName + ", deployment=" + this.deployment + ")";
        }
    }
}

