/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud.model;

import javax.annotation.Nonnull;

public class SpringCloudSku {
    @Nonnull
    private final String name;
    @Nonnull
    private final String tier;
    private final Integer capacity;

    SpringCloudSku(@Nonnull String name, @Nonnull String tier, Integer capacity) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (tier == null) {
            throw new NullPointerException("tier is marked non-null but is null");
        }
        this.name = name;
        this.tier = tier;
        this.capacity = capacity;
    }

    public static SpringCloudSkuBuilder builder() {
        return new SpringCloudSkuBuilder();
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getTier() {
        return this.tier;
    }

    public Integer getCapacity() {
        return this.capacity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringCloudSku)) {
            return false;
        }
        SpringCloudSku other = (SpringCloudSku)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$capacity = this.getCapacity();
        Integer other$capacity = other.getCapacity();
        if (this$capacity == null ? other$capacity != null : !((Object)this$capacity).equals(other$capacity)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$tier = this.getTier();
        String other$tier = other.getTier();
        return !(this$tier == null ? other$tier != null : !this$tier.equals(other$tier));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpringCloudSku;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $capacity = this.getCapacity();
        result = result * 59 + ($capacity == null ? 43 : ((Object)$capacity).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $tier = this.getTier();
        result = result * 59 + ($tier == null ? 43 : $tier.hashCode());
        return result;
    }

    public static class SpringCloudSkuBuilder {
        private String name;
        private String tier;
        private Integer capacity;

        SpringCloudSkuBuilder() {
        }

        public SpringCloudSkuBuilder name(@Nonnull String name) {
            this.name = name;
            return this;
        }

        public SpringCloudSkuBuilder tier(@Nonnull String tier) {
            this.tier = tier;
            return this;
        }

        public SpringCloudSkuBuilder capacity(Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        public SpringCloudSku build() {
            return new SpringCloudSku(this.name, this.tier, this.capacity);
        }

        public String toString() {
            return "SpringCloudSku.SpringCloudSkuBuilder(name=" + this.name + ", tier=" + this.tier + ", capacity=" + this.capacity + ")";
        }
    }
}

