/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud.task;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.springcloud.AzureSpringCloud;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppDraft;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentDraft;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudAppConfig;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudDeploymentConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class DeploySpringCloudAppTask
extends AzureTask<SpringCloudDeployment> {
    public static final String DEFAULT_DEPLOYMENT_NAME = "default";
    private final SpringCloudAppConfig config;
    @Nonnull
    private final List<AzureTask<?>> subTasks;
    private SpringCloudDeploymentDraft deployment;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public DeploySpringCloudAppTask(SpringCloudAppConfig appConfig) {
        this.config = appConfig;
        this.subTasks = this.initTasks();
    }

    @Nonnull
    private List<AzureTask<?>> initTasks() {
        SpringCloudDeploymentConfig deploymentConfig = this.config.getDeployment();
        String clusterName = this.config.getClusterName();
        String appName = this.config.getAppName();
        String resourceGroup = this.config.getResourceGroup();
        SpringCloudCluster cluster = (SpringCloudCluster)((AzureSpringCloud)Azure.az(AzureSpringCloud.class)).clusters(this.config.getSubscriptionId()).get(clusterName, resourceGroup);
        Optional.ofNullable(cluster).orElseThrow(() -> new AzureToolkitRuntimeException(String.format("Azure Spring Apps(%s) is not found in subscription(%s).", clusterName, this.config.getSubscriptionId())));
        SpringCloudAppDraft app = (SpringCloudAppDraft)cluster.apps().updateOrCreate(appName, resourceGroup);
        String deploymentName = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{deploymentConfig.getDeploymentName(), this.config.getActiveDeploymentName(), app.getActiveDeploymentName(), DEFAULT_DEPLOYMENT_NAME});
        this.deployment = (SpringCloudDeploymentDraft)app.deployments().updateOrCreate(deploymentName, resourceGroup);
        boolean toCreateApp = !app.exists();
        boolean toCreateDeployment = !this.deployment.exists() && (!toCreateApp || !DEFAULT_DEPLOYMENT_NAME.equals(this.deployment.getName()));
        this.config.setActiveDeploymentName((String)StringUtils.firstNonBlank((CharSequence[])new String[]{app.getActiveDeploymentName(), toCreateDeployment ? deploymentName : null}));
        OperationContext.action().setTelemetryProperty("subscriptionId", this.config.getSubscriptionId());
        OperationContext.current().setTelemetryProperty("isCreateNewApp", String.valueOf(toCreateApp));
        OperationContext.current().setTelemetryProperty("isCreateDeployment", String.valueOf(toCreateDeployment));
        OperationContext.current().setTelemetryProperty("isDeploymentNameGiven", String.valueOf(StringUtils.isNotEmpty((CharSequence)deploymentConfig.getDeploymentName())));
        AzureString CREATE_APP_TITLE = AzureString.format((String)"Create new app({0}) in Azure Spring Apps({1})", (Object[])new Object[]{appName, clusterName});
        AzureString UPDATE_APP_TITLE = AzureString.format((String)"Update app({0}) of Azure Spring Apps({1})", (Object[])new Object[]{appName, clusterName});
        AzureString CREATE_DEPLOYMENT_TITLE = AzureString.format((String)"Create new deployment({0}) in app({1})", (Object[])new Object[]{deploymentName, appName});
        AzureString UPDATE_DEPLOYMENT_TITLE = AzureString.format((String)"Update deployment({0}) of app({1})", (Object[])new Object[]{deploymentName, appName});
        AzureString MODIFY_DEPLOYMENT_TITLE = toCreateDeployment ? CREATE_DEPLOYMENT_TITLE : UPDATE_DEPLOYMENT_TITLE;
        ArrayList tasks = new ArrayList();
        this.deployment.setConfig(this.config.getDeployment());
        app.setConfig(this.config);
        if (toCreateApp) {
            tasks.add(new AzureTask(CREATE_APP_TITLE, () -> ((SpringCloudAppDraft)app).createIfNotExist()));
        }
        tasks.add(new AzureTask(MODIFY_DEPLOYMENT_TITLE, () -> this.deployment.commit()));
        tasks.add(new AzureTask(UPDATE_APP_TITLE, () -> {
            SpringCloudAppDraft draft = (SpringCloudAppDraft)app.update();
            draft.setConfig(this.config);
            draft.updateIfExist();
        }));
        tasks.add(new AzureTask(() -> {
            app.reset();
            this.deployment.reset();
        }));
        return tasks;
    }

    @AzureOperation(name="springcloud.create_update_app.app", params={"this.config.getAppName()"}, type=AzureOperation.Type.SERVICE)
    public SpringCloudDeployment doExecute() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            for (AzureTask<?> t : this.subTasks) {
                t.getBody().call();
            }
            SpringCloudDeploymentDraft springCloudDeploymentDraft = this.deployment;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return springCloudDeploymentDraft;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public SpringCloudAppConfig getConfig() {
        return this.config;
    }

    @Nonnull
    public List<AzureTask<?>> getSubTasks() {
        return this.subTasks;
    }

    public SpringCloudDeploymentDraft getDeployment() {
        return this.deployment;
    }

    static {
        DeploySpringCloudAppTask.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeploySpringCloudAppTask.java", DeploySpringCloudAppTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doExecute", "com.microsoft.azure.toolkit.lib.springcloud.task.DeploySpringCloudAppTask", "", "", "java.lang.Exception", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment"), 98);
    }
}

