/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.resourcemanager.appplatform.fluent.models.ServiceResourceInner;
import com.azure.resourcemanager.appplatform.models.ProvisioningState;
import com.azure.resourcemanager.appplatform.models.Sku;
import com.azure.resourcemanager.appplatform.models.SkuName;
import com.azure.resourcemanager.appplatform.models.SpringService;
import com.azure.resourcemanager.appplatform.models.TestKeys;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppModule;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudClusterModule;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudServiceSubscription;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SpringCloudCluster
extends AbstractAzResource<SpringCloudCluster, SpringCloudServiceSubscription, SpringService> {
    @Nonnull
    private final SpringCloudAppModule appModule;

    protected SpringCloudCluster(@Nonnull String name, @Nonnull String resourceGroup, @Nonnull SpringCloudClusterModule module) {
        super(name, resourceGroup, (AbstractAzResourceModule)module);
        this.appModule = new SpringCloudAppModule(this);
    }

    protected SpringCloudCluster(@Nonnull SpringCloudCluster origin) {
        super((AbstractAzResource)origin);
        this.appModule = origin.appModule;
    }

    protected SpringCloudCluster(@Nonnull SpringService remote, @Nonnull SpringCloudClusterModule module) {
        super(remote.name(), remote.resourceGroupName(), (AbstractAzResourceModule)module);
        this.appModule = new SpringCloudAppModule(this);
        this.setRemote(remote);
    }

    @Nonnull
    public String loadStatus(@Nonnull SpringService remote) {
        ProvisioningState state = ((ServiceResourceInner)((SpringService)remote.refresh()).innerModel()).properties().provisioningState();
        return state.toString();
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, SpringCloudCluster, ?>> getSubModules() {
        return Collections.singletonList(this.appModule);
    }

    @Nonnull
    public SpringCloudAppModule apps() {
        return this.appModule;
    }

    @Nullable
    public String getTestEndpoint() {
        return Optional.ofNullable((SpringService)this.getRemote()).map(SpringService::listTestKeys).map(TestKeys::primaryTestEndpoint).orElse(null);
    }

    @Nullable
    public String getTestKey() {
        return Optional.ofNullable((SpringService)this.getRemote()).map(SpringService::listTestKeys).map(TestKeys::primaryKey).orElse(null);
    }

    @Nonnull
    public String getSku() {
        return Optional.ofNullable((SpringService)this.getRemote()).map(SpringService::sku).map(Sku::name).orElse(SkuName.B0.toString());
    }

    public boolean isEnterpriseTier() {
        return this.remoteOptional().map(SpringService::sku).filter(s -> s.name().equalsIgnoreCase(SkuName.E0.toString())).isPresent();
    }

    @Nonnull
    public SpringCloudAppModule getAppModule() {
        return this.appModule;
    }
}

