/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.core.util.ExpandableStringEnum;
import com.azure.resourcemanager.appplatform.models.DeploymentInstance;
import com.azure.resourcemanager.appplatform.models.DeploymentSettings;
import com.azure.resourcemanager.appplatform.models.SpringAppDeployment;
import com.google.common.base.Charsets;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentModule;
import com.microsoft.azure.toolkit.lib.springcloud.Utils;
import io.netty.handler.codec.http.HttpHeaders;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

public class SpringCloudDeployment
extends AbstractAzResource<SpringCloudDeployment, SpringCloudApp, SpringAppDeployment> {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    protected SpringCloudDeployment(@Nonnull String name, @Nonnull SpringCloudDeploymentModule module) {
        super(name, (AbstractAzResourceModule)module);
    }

    protected SpringCloudDeployment(@Nonnull SpringCloudDeployment origin) {
        super((AbstractAzResource)origin);
    }

    protected SpringCloudDeployment(@Nonnull SpringAppDeployment remote, @Nonnull SpringCloudDeploymentModule module) {
        super(remote.name(), (AbstractAzResourceModule)module);
        this.setRemote(remote);
    }

    @AzureOperation(name="resource.start_resource.resource", params={"this.name()"}, type=AzureOperation.Type.SERVICE)
    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> Objects.requireNonNull((SpringAppDeployment)this.getRemote()).start(), "Starting");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="resource.stop_resource.resource", params={"this.name()"}, type=AzureOperation.Type.SERVICE)
    public void stop() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> Objects.requireNonNull((SpringAppDeployment)this.getRemote()).stop(), "Stopping");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="resource.restart_resource.resource", params={"this.name()"}, type=AzureOperation.Type.SERVICE)
    public void restart() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> Objects.requireNonNull((SpringAppDeployment)this.getRemote()).restart(), "Restarting");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    public String loadStatus(@Nonnull SpringAppDeployment remote) {
        return Optional.of(remote).map(SpringAppDeployment::status).map(ExpandableStringEnum::toString).orElse("Unknown");
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, SpringCloudDeployment, ?>> getSubModules() {
        return Collections.emptyList();
    }

    @Nonnull
    public Flux<String> streamLogs(String instance) {
        return this.streamLogs(instance, 0, 10, 0, true);
    }

    @Nonnull
    public Flux<String> streamLogs(String instance, int sinceSeconds, int tailLines, int limitBytes, boolean follow) {
        HttpClient client = HttpClient.create().keepAlive(true);
        URIBuilder endpoint = new URIBuilder(((SpringCloudApp)this.getParent()).getLogStreamingEndpoint(instance));
        endpoint.addParameter("follow", String.valueOf(follow));
        if (sinceSeconds > 0) {
            endpoint.addParameter("sinceSeconds", String.valueOf(sinceSeconds));
        }
        if (tailLines > 0) {
            endpoint.addParameter("tailLines", String.valueOf(tailLines));
        }
        if (limitBytes > 0) {
            endpoint.addParameter("limitBytes", String.valueOf(limitBytes));
        }
        String password = ((SpringCloudCluster)((SpringCloudApp)this.getParent()).getParent()).getTestKey();
        String userPass = "primary:" + password;
        String basicAuth = "Basic " + new String(Base64.getEncoder().encode(userPass.getBytes()));
        Consumer<HttpHeaders> headerBuilder = header -> header.set("Authorization", (Object)basicAuth);
        return ((HttpClient.ResponseReceiver)client.headers(headerBuilder).responseTimeout(Duration.of(10L, ChronoUnit.MINUTES)).get().uri(endpoint.build())).response((resp, cont) -> resp.status().code() == 200 ? cont.asString(Charsets.UTF_8) : Mono.empty());
    }

    @AzureOperation(name="springcloud.wait_until_deployment_ready.deployment|app", params={"this.entity().getName()", "this.app.name()"}, type=AzureOperation.Type.SERVICE)
    public boolean waitUntilReady(int timeoutInSeconds) {
        int n = timeoutInSeconds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AzureMessager.getMessager().info("Getting deployment status...");
            SpringCloudDeployment deployment = Utils.pollUntil(() -> {
                this.refresh();
                return this;
            }, Utils::isDeploymentDone, timeoutInSeconds);
            boolean bl = Utils.isDeploymentDone(deployment);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nullable
    public Double getCpu() {
        return Optional.ofNullable((SpringAppDeployment)this.getRemote()).map(SpringAppDeployment::memoryInGB).orElse(null);
    }

    @Nullable
    public Double getMemoryInGB() {
        return Optional.ofNullable((SpringAppDeployment)this.getRemote()).map(SpringAppDeployment::cpu).orElse(null);
    }

    @Nullable
    public String getRuntimeVersion() {
        return Optional.ofNullable((SpringAppDeployment)this.getRemote()).map(SpringAppDeployment::runtimeVersion).map(ExpandableStringEnum::toString).orElse(null);
    }

    @Nullable
    public String getJvmOptions() {
        return Optional.ofNullable((SpringAppDeployment)this.getRemote()).map(SpringAppDeployment::jvmOptions).orElse(null);
    }

    @Nullable
    public Map<String, String> getEnvironmentVariables() {
        return Optional.ofNullable((SpringAppDeployment)this.getRemote()).map(SpringAppDeployment::settings).map(DeploymentSettings::environmentVariables).map(v -> {
            HashMap variables = new HashMap(v);
            if (((SpringCloudCluster)((SpringCloudApp)this.getParent()).getParent()).isEnterpriseTier() && StringUtils.isBlank((CharSequence)((CharSequence)variables.get("JAVA_OPTS")))) {
                variables.remove("JAVA_OPTS");
            }
            return variables;
        }).orElse(null);
    }

    @Nonnull
    public List<DeploymentInstance> getInstances() {
        if (Objects.nonNull(this.getRemote())) {
            return ((SpringAppDeployment)this.getRemote()).instances();
        }
        return new ArrayList<DeploymentInstance>();
    }

    @Nullable
    public Integer getInstanceNum() {
        if (Objects.nonNull(this.getRemote())) {
            return ((SpringAppDeployment)this.getRemote()).instances().size();
        }
        return null;
    }

    @Nonnull
    public Boolean isActive() {
        return Optional.ofNullable((SpringAppDeployment)this.getRemote()).map(SpringAppDeployment::isActive).orElse(false);
    }

    static {
        SpringCloudDeployment.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpringCloudDeployment.java", SpringCloudDeployment.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment", "", "", "", "void"), 60);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment", "", "", "", "void"), 65);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "restart", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment", "", "", "", "void"), 70);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilReady", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment", "int", "timeoutInSeconds", "", "boolean"), 126);
    }
}

