/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud.config;

import com.azure.resourcemanager.appplatform.models.DeploymentInstance;
import com.microsoft.azure.toolkit.lib.common.model.IArtifact;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentDraft;
import com.microsoft.azure.toolkit.lib.springcloud.model.SpringCloudPersistentDisk;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SpringCloudDeploymentConfig {
    private static final Logger log = LoggerFactory.getLogger(SpringCloudDeploymentConfig.class);
    @Nullable
    private Double cpu;
    @Nullable
    private Double memoryInGB;
    private Integer instanceCount;
    private String deploymentName;
    @Nullable
    private String jvmOptions;
    private String runtimeVersion;
    @Nonnull
    private Boolean enablePersistentStorage;
    @Nullable
    private Map<String, String> environment;
    @Nullable
    private IArtifact artifact;

    @Nonnull
    public Boolean isEnablePersistentStorage() {
        return BooleanUtils.isTrue((Boolean)this.enablePersistentStorage);
    }

    @Nullable
    public String getJavaVersion() {
        return SpringCloudDeploymentDraft.formalizeRuntimeVersion(this.runtimeVersion).toString();
    }

    @Nullable
    @Contract(value="null -> null")
    public static SpringCloudDeploymentConfig fromDeployment(@Nullable SpringCloudDeployment deployment) {
        if (Objects.isNull((Object)deployment)) {
            return null;
        }
        List<DeploymentInstance> instances = deployment.getInstances();
        SpringCloudPersistentDisk disk = ((SpringCloudApp)deployment.getParent()).getPersistentDisk();
        SpringCloudDeploymentConfig deploymentConfig = SpringCloudDeploymentConfig.builder().build();
        deploymentConfig.setRuntimeVersion(deployment.getRuntimeVersion());
        deploymentConfig.setEnablePersistentStorage(Objects.nonNull(disk) && disk.getSizeInGB() > 0);
        deploymentConfig.setCpu(deployment.getCpu());
        deploymentConfig.setMemoryInGB(deployment.getMemoryInGB());
        deploymentConfig.setInstanceCount(instances.size());
        deploymentConfig.setJvmOptions(Optional.ofNullable(deployment.getJvmOptions()).map(String::trim).orElse(""));
        deploymentConfig.setEnvironment(Optional.ofNullable(deployment.getEnvironmentVariables()).orElse(new HashMap()));
        return deploymentConfig;
    }

    private static Double $default$cpu() {
        return 1.0;
    }

    private static Double $default$memoryInGB() {
        return 1.0;
    }

    private static String $default$runtimeVersion() {
        return SpringCloudDeploymentDraft.DEFAULT_RUNTIME_VERSION.toString();
    }

    private static Boolean $default$enablePersistentStorage() {
        return false;
    }

    public static SpringCloudDeploymentConfigBuilder builder() {
        return new SpringCloudDeploymentConfigBuilder();
    }

    @Nullable
    public Double getCpu() {
        return this.cpu;
    }

    @Nullable
    public Double getMemoryInGB() {
        return this.memoryInGB;
    }

    public Integer getInstanceCount() {
        return this.instanceCount;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    @Nullable
    public String getJvmOptions() {
        return this.jvmOptions;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    @Nonnull
    public Boolean getEnablePersistentStorage() {
        return this.enablePersistentStorage;
    }

    @Nullable
    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Nullable
    public IArtifact getArtifact() {
        return this.artifact;
    }

    public void setCpu(@Nullable Double cpu) {
        this.cpu = cpu;
    }

    public void setMemoryInGB(@Nullable Double memoryInGB) {
        this.memoryInGB = memoryInGB;
    }

    public void setInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public void setJvmOptions(@Nullable String jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
    }

    public void setEnablePersistentStorage(@Nonnull Boolean enablePersistentStorage) {
        if (enablePersistentStorage == null) {
            throw new NullPointerException("enablePersistentStorage is marked non-null but is null");
        }
        this.enablePersistentStorage = enablePersistentStorage;
    }

    public void setEnvironment(@Nullable Map<String, String> environment) {
        this.environment = environment;
    }

    public void setArtifact(@Nullable IArtifact artifact) {
        this.artifact = artifact;
    }

    public SpringCloudDeploymentConfig() {
        this.cpu = SpringCloudDeploymentConfig.$default$cpu();
        this.memoryInGB = SpringCloudDeploymentConfig.$default$memoryInGB();
        this.runtimeVersion = SpringCloudDeploymentConfig.$default$runtimeVersion();
        this.enablePersistentStorage = SpringCloudDeploymentConfig.$default$enablePersistentStorage();
    }

    public SpringCloudDeploymentConfig(@Nullable Double cpu, @Nullable Double memoryInGB, Integer instanceCount, String deploymentName, @Nullable String jvmOptions, String runtimeVersion, @Nonnull Boolean enablePersistentStorage, @Nullable Map<String, String> environment, @Nullable IArtifact artifact) {
        if (enablePersistentStorage == null) {
            throw new NullPointerException("enablePersistentStorage is marked non-null but is null");
        }
        this.cpu = cpu;
        this.memoryInGB = memoryInGB;
        this.instanceCount = instanceCount;
        this.deploymentName = deploymentName;
        this.jvmOptions = jvmOptions;
        this.runtimeVersion = runtimeVersion;
        this.enablePersistentStorage = enablePersistentStorage;
        this.environment = environment;
        this.artifact = artifact;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringCloudDeploymentConfig)) {
            return false;
        }
        SpringCloudDeploymentConfig other = (SpringCloudDeploymentConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$cpu = this.getCpu();
        Double other$cpu = other.getCpu();
        if (this$cpu == null ? other$cpu != null : !((Object)this$cpu).equals(other$cpu)) {
            return false;
        }
        Double this$memoryInGB = this.getMemoryInGB();
        Double other$memoryInGB = other.getMemoryInGB();
        if (this$memoryInGB == null ? other$memoryInGB != null : !((Object)this$memoryInGB).equals(other$memoryInGB)) {
            return false;
        }
        Integer this$instanceCount = this.getInstanceCount();
        Integer other$instanceCount = other.getInstanceCount();
        if (this$instanceCount == null ? other$instanceCount != null : !((Object)this$instanceCount).equals(other$instanceCount)) {
            return false;
        }
        Boolean this$enablePersistentStorage = this.getEnablePersistentStorage();
        Boolean other$enablePersistentStorage = other.getEnablePersistentStorage();
        if (this$enablePersistentStorage == null ? other$enablePersistentStorage != null : !((Object)this$enablePersistentStorage).equals(other$enablePersistentStorage)) {
            return false;
        }
        String this$deploymentName = this.getDeploymentName();
        String other$deploymentName = other.getDeploymentName();
        if (this$deploymentName == null ? other$deploymentName != null : !this$deploymentName.equals(other$deploymentName)) {
            return false;
        }
        String this$jvmOptions = this.getJvmOptions();
        String other$jvmOptions = other.getJvmOptions();
        if (this$jvmOptions == null ? other$jvmOptions != null : !this$jvmOptions.equals(other$jvmOptions)) {
            return false;
        }
        String this$runtimeVersion = this.getRuntimeVersion();
        String other$runtimeVersion = other.getRuntimeVersion();
        if (this$runtimeVersion == null ? other$runtimeVersion != null : !this$runtimeVersion.equals(other$runtimeVersion)) {
            return false;
        }
        Map<String, String> this$environment = this.getEnvironment();
        Map<String, String> other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !((Object)this$environment).equals(other$environment)) {
            return false;
        }
        IArtifact this$artifact = this.getArtifact();
        IArtifact other$artifact = other.getArtifact();
        return !(this$artifact == null ? other$artifact != null : !this$artifact.equals(other$artifact));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpringCloudDeploymentConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $cpu = this.getCpu();
        result = result * 59 + ($cpu == null ? 43 : ((Object)$cpu).hashCode());
        Double $memoryInGB = this.getMemoryInGB();
        result = result * 59 + ($memoryInGB == null ? 43 : ((Object)$memoryInGB).hashCode());
        Integer $instanceCount = this.getInstanceCount();
        result = result * 59 + ($instanceCount == null ? 43 : ((Object)$instanceCount).hashCode());
        Boolean $enablePersistentStorage = this.getEnablePersistentStorage();
        result = result * 59 + ($enablePersistentStorage == null ? 43 : ((Object)$enablePersistentStorage).hashCode());
        String $deploymentName = this.getDeploymentName();
        result = result * 59 + ($deploymentName == null ? 43 : $deploymentName.hashCode());
        String $jvmOptions = this.getJvmOptions();
        result = result * 59 + ($jvmOptions == null ? 43 : $jvmOptions.hashCode());
        String $runtimeVersion = this.getRuntimeVersion();
        result = result * 59 + ($runtimeVersion == null ? 43 : $runtimeVersion.hashCode());
        Map<String, String> $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : ((Object)$environment).hashCode());
        IArtifact $artifact = this.getArtifact();
        result = result * 59 + ($artifact == null ? 43 : $artifact.hashCode());
        return result;
    }

    public static class SpringCloudDeploymentConfigBuilder {
        private boolean cpu$set;
        private Double cpu$value;
        private boolean memoryInGB$set;
        private Double memoryInGB$value;
        private Integer instanceCount;
        private String deploymentName;
        private String jvmOptions;
        private boolean runtimeVersion$set;
        private String runtimeVersion$value;
        private boolean enablePersistentStorage$set;
        private Boolean enablePersistentStorage$value;
        private Map<String, String> environment;
        private IArtifact artifact;

        SpringCloudDeploymentConfigBuilder() {
        }

        public SpringCloudDeploymentConfigBuilder cpu(@Nullable Double cpu) {
            this.cpu$value = cpu;
            this.cpu$set = true;
            return this;
        }

        public SpringCloudDeploymentConfigBuilder memoryInGB(@Nullable Double memoryInGB) {
            this.memoryInGB$value = memoryInGB;
            this.memoryInGB$set = true;
            return this;
        }

        public SpringCloudDeploymentConfigBuilder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public SpringCloudDeploymentConfigBuilder deploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public SpringCloudDeploymentConfigBuilder jvmOptions(@Nullable String jvmOptions) {
            this.jvmOptions = jvmOptions;
            return this;
        }

        public SpringCloudDeploymentConfigBuilder runtimeVersion(String runtimeVersion) {
            this.runtimeVersion$value = runtimeVersion;
            this.runtimeVersion$set = true;
            return this;
        }

        public SpringCloudDeploymentConfigBuilder enablePersistentStorage(@Nonnull Boolean enablePersistentStorage) {
            this.enablePersistentStorage$value = enablePersistentStorage;
            this.enablePersistentStorage$set = true;
            return this;
        }

        public SpringCloudDeploymentConfigBuilder environment(@Nullable Map<String, String> environment) {
            this.environment = environment;
            return this;
        }

        public SpringCloudDeploymentConfigBuilder artifact(@Nullable IArtifact artifact) {
            this.artifact = artifact;
            return this;
        }

        public SpringCloudDeploymentConfig build() {
            Double cpu$value = this.cpu$value;
            if (!this.cpu$set) {
                cpu$value = SpringCloudDeploymentConfig.$default$cpu();
            }
            Double memoryInGB$value = this.memoryInGB$value;
            if (!this.memoryInGB$set) {
                memoryInGB$value = SpringCloudDeploymentConfig.$default$memoryInGB();
            }
            String runtimeVersion$value = this.runtimeVersion$value;
            if (!this.runtimeVersion$set) {
                runtimeVersion$value = SpringCloudDeploymentConfig.$default$runtimeVersion();
            }
            Boolean enablePersistentStorage$value = this.enablePersistentStorage$value;
            if (!this.enablePersistentStorage$set) {
                enablePersistentStorage$value = SpringCloudDeploymentConfig.$default$enablePersistentStorage();
            }
            return new SpringCloudDeploymentConfig(cpu$value, memoryInGB$value, this.instanceCount, this.deploymentName, this.jvmOptions, runtimeVersion$value, enablePersistentStorage$value, this.environment, this.artifact);
        }

        public String toString() {
            return "SpringCloudDeploymentConfig.SpringCloudDeploymentConfigBuilder(cpu$value=" + this.cpu$value + ", memoryInGB$value=" + this.memoryInGB$value + ", instanceCount=" + this.instanceCount + ", deploymentName=" + this.deploymentName + ", jvmOptions=" + this.jvmOptions + ", runtimeVersion$value=" + this.runtimeVersion$value + ", enablePersistentStorage$value=" + this.enablePersistentStorage$value + ", environment=" + this.environment + ", artifact=" + this.artifact + ")";
        }
    }
}

