/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenRequestContext;
import com.azure.identity.implementation.util.ScopeUtil;
import com.azure.resourcemanager.appplatform.models.DeploymentInstance;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.utils.StreamingLogSupport;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppInstanceModule;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SpringCloudAppInstance
extends AbstractAzResource<SpringCloudAppInstance, SpringCloudDeployment, DeploymentInstance>
implements StreamingLogSupport {
    private static final String REMOTE_URL_TEMPLATE = "https://%s/api/remoteDebugging/apps/%s/deployments/%s/instances/%s?port=%s";

    protected SpringCloudAppInstance(@Nonnull String name, @Nonnull SpringCloudAppInstanceModule module) {
        super(name, (AbstractAzResourceModule)module);
    }

    protected SpringCloudAppInstance(@Nonnull DeploymentInstance remote, @Nonnull SpringCloudAppInstanceModule module) {
        super(remote.name(), (AbstractAzResourceModule)module);
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.emptyList();
    }

    @Nonnull
    public String loadStatus(@Nonnull DeploymentInstance remote) {
        return remote.status();
    }

    public String getDiscoveryStatus() {
        DeploymentInstance deploymentInstance = (DeploymentInstance)this.getRemote(new boolean[0]);
        if (Objects.nonNull(deploymentInstance)) {
            return deploymentInstance.discoveryStatus();
        }
        return "Unknown";
    }

    public String getRemoteDebuggingUrl() {
        SpringCloudApp app = (SpringCloudApp)((SpringCloudDeployment)this.getParent()).getParent();
        return String.format(REMOTE_URL_TEMPLATE, ((SpringCloudCluster)app.getParent()).getFqdn(), app.getName(), ((SpringCloudDeployment)this.getParent()).getName(), this.getName(), ((SpringCloudDeployment)this.getParent()).getRemoteDebuggingPort());
    }

    @Nullable
    public String getLogStreamEndpoint() {
        SpringCloudApp app = (SpringCloudApp)((SpringCloudDeployment)this.getParent()).getParent();
        SpringCloudCluster service = (SpringCloudCluster)app.getParent();
        if (service.isConsumptionTier()) {
            return String.format("https://%s/proxy/logstream%s?follow=true&tailLines=300&tenantId=%s", service.getFqdn(), this.getId(), this.getSubscription().getTenantId());
        }
        return Optional.ofNullable(app.getTestEndpoint()).map(e -> String.format("%s/api/logstream/apps/%s/instances/%s", e.replace(".test", ""), app.getName(), this.getName())).orElse(null);
    }

    public String getLogStreamAuthorization() {
        SpringCloudApp app = (SpringCloudApp)((SpringCloudDeployment)this.getParent()).getParent();
        SpringCloudCluster service = (SpringCloudCluster)app.getParent();
        if (service.isConsumptionTier()) {
            Account account = ((AzureAccount)Azure.az(AzureAccount.class)).account();
            String[] scopes = ScopeUtil.resourceToScopes((String)account.getEnvironment().getManagementEndpoint());
            TokenRequestContext request = new TokenRequestContext().addScopes(scopes);
            String accessToken = Objects.requireNonNull((AccessToken)account.getTokenCredential(this.getSubscriptionId()).getToken(request).block()).getToken();
            return "Bearer " + accessToken;
        }
        String password = service.getTestKey();
        String userPass = "primary:" + password;
        return "Basic " + new String(Base64.getEncoder().encode(userPass.getBytes()));
    }
}

