/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.resourcemanager.appplatform.models.SpringApp;
import com.azure.resourcemanager.appplatform.models.SpringApps;
import com.azure.resourcemanager.appplatform.models.SpringService;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppDraft;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SpringCloudAppModule
extends AbstractAzResourceModule<SpringCloudApp, SpringCloudCluster, SpringApp> {
    public static final String NAME = "apps";

    public SpringCloudAppModule(@Nonnull SpringCloudCluster parent) {
        super(NAME, (AzResource)parent);
    }

    public SpringApps getClient() {
        return Optional.ofNullable((SpringService)((SpringCloudCluster)this.parent).getRemote(new boolean[0])).map(SpringService::apps).orElse(null);
    }

    @Nonnull
    protected SpringCloudAppDraft newDraftForCreate(@Nonnull String name, String resourceGroupName) {
        return new SpringCloudAppDraft(name, this);
    }

    @Nonnull
    protected SpringCloudAppDraft newDraftForUpdate(@Nonnull SpringCloudApp origin) {
        return new SpringCloudAppDraft(origin);
    }

    @Nonnull
    protected SpringCloudApp newResource(@Nonnull SpringApp remote) {
        return new SpringCloudApp(remote, this);
    }

    @Nonnull
    protected SpringCloudApp newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new SpringCloudApp(name, this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Spring app";
    }
}

