/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud.task;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.common.utils.Debouncer;
import com.microsoft.azure.toolkit.lib.common.utils.TailingDebouncer;
import com.microsoft.azure.toolkit.lib.springcloud.AzureSpringCloud;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppDraft;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentDraft;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudAppConfig;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudDeploymentConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import reactor.core.Disposable;
import reactor.core.scheduler.Schedulers;

public class DeploySpringCloudAppTask
extends AzureTask<SpringCloudDeployment> {
    public static final String DEFAULT_DEPLOYMENT_NAME = "default";
    private final SpringCloudAppConfig config;
    @Nonnull
    private final List<AzureTask<?>> subTasks;
    private SpringCloudDeployment deployment;
    private final boolean openStreamingLogOnFailure;
    private final boolean waitDeploymentComplete;
    private static final int TIMEOUT_IN_SECONDS = 60;
    private static final String GET_APP_STATUS_TIMEOUT = "Deployment succeeded but the app is still starting, you can check the app status from Azure Portal.";
    private static final String START_APP = "Starting Web App after deploying artifacts...";
    private Disposable disposable;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public DeploySpringCloudAppTask(SpringCloudAppConfig appConfig) {
        this(appConfig, false, false);
    }

    public DeploySpringCloudAppTask(SpringCloudAppConfig appConfig, boolean openStreamingLogOnFailure, boolean waitDeploymentComplete) {
        this.config = appConfig;
        this.subTasks = this.initTasks();
        this.openStreamingLogOnFailure = openStreamingLogOnFailure;
        this.waitDeploymentComplete = waitDeploymentComplete;
    }

    @Nonnull
    private List<AzureTask<?>> initTasks() {
        SpringCloudDeploymentConfig deploymentConfig = this.config.getDeployment();
        String subscriptionId = Optional.ofNullable(this.config.getSubscriptionId()).filter(StringUtils::isNotBlank).orElseThrow(() -> new AzureToolkitRuntimeException("'subscriptionId' is required"));
        String clusterName = Optional.ofNullable(this.config.getClusterName()).filter(StringUtils::isNotBlank).orElseThrow(() -> new AzureToolkitRuntimeException("'clusterName' is required"));
        String appName = Optional.ofNullable(this.config.getAppName()).filter(StringUtils::isNotBlank).orElseThrow(() -> new AzureToolkitRuntimeException("'appName' is required"));
        String resourceGroup = this.config.getResourceGroup();
        SpringCloudCluster cluster = ((AzureSpringCloud)Azure.az(AzureSpringCloud.class)).clusters(subscriptionId).get(clusterName, resourceGroup);
        Optional.ofNullable(cluster).orElseThrow(() -> new AzureToolkitRuntimeException(String.format("Azure Spring Apps(%s) is not found in resource group(%s) of subscription(%s).", clusterName, resourceGroup, subscriptionId)));
        SpringCloudAppDraft app = (SpringCloudAppDraft)cluster.apps().updateOrCreate(appName, resourceGroup);
        String deploymentName = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{deploymentConfig.getDeploymentName(), this.config.getActiveDeploymentName(), app.getActiveDeploymentName(), DEFAULT_DEPLOYMENT_NAME});
        boolean toCreateApp = !app.exists();
        boolean toCreateDeployment = !toCreateApp && !app.deployments().exists(deploymentName, resourceGroup);
        this.config.setActiveDeploymentName((String)StringUtils.firstNonBlank((CharSequence[])new String[]{app.getActiveDeploymentName(), toCreateApp || toCreateDeployment ? deploymentName : null}));
        OperationContext.action().setTelemetryProperty("subscriptionId", subscriptionId);
        OperationContext.current().setTelemetryProperty("isCreateNewApp", String.valueOf(toCreateApp));
        OperationContext.current().setTelemetryProperty("isCreateDeployment", String.valueOf(toCreateApp || toCreateDeployment));
        OperationContext.current().setTelemetryProperty("isDeploymentNameGiven", String.valueOf(StringUtils.isNotEmpty((CharSequence)deploymentConfig.getDeploymentName())));
        AzureString CREATE_APP_TITLE = AzureString.format((String)"Create new app({0}) and deployment({1}) in Azure Spring Apps({2})", (Object[])new Object[]{appName, deploymentName, clusterName});
        AzureString UPDATE_APP_TITLE = AzureString.format((String)"Update app({0}) of Azure Spring Apps({1})", (Object[])new Object[]{appName, clusterName});
        AzureString CREATE_DEPLOYMENT_TITLE = AzureString.format((String)"Create new deployment({0}) in app({1})", (Object[])new Object[]{deploymentName, appName});
        AzureString UPDATE_DEPLOYMENT_TITLE = AzureString.format((String)"Update deployment({0}) of app({1})", (Object[])new Object[]{deploymentName, appName});
        AzureString MODIFY_DEPLOYMENT_TITLE = toCreateDeployment ? CREATE_DEPLOYMENT_TITLE : UPDATE_DEPLOYMENT_TITLE;
        ArrayList tasks = new ArrayList();
        app.setConfig(this.config);
        if (toCreateApp) {
            tasks.add(new AzureTask(CREATE_APP_TITLE, () -> ((SpringCloudAppDraft)app).createIfNotExist()));
        }
        tasks.add(new AzureTask(MODIFY_DEPLOYMENT_TITLE, () -> {
            SpringCloudDeploymentDraft draft = (SpringCloudDeploymentDraft)app.deployments().updateOrCreate(deploymentName, resourceGroup);
            draft.setConfig(this.config.getDeployment());
            try {
                this.deployment = (SpringCloudDeployment)draft.commit();
            }
            catch (Exception e) {
                app.refresh();
                this.deployment = app.getActiveDeployment();
                this.startStreamingLog(true);
                throw new AzureToolkitRuntimeException((Throwable)e);
            }
        }));
        tasks.add(new AzureTask(UPDATE_APP_TITLE, () -> {
            SpringCloudAppDraft draft = (SpringCloudAppDraft)app.update();
            draft.setConfig(this.config);
            draft.updateIfExist();
            app.refresh();
        }));
        tasks.add(new AzureTask(app::reset));
        if (this.waitDeploymentComplete) {
            tasks.add(new AzureTask(this::startApp));
        }
        return tasks;
    }

    @AzureOperation(name="internal/springcloud.create_update_app.app", params={"this.config.getAppName()"})
    public SpringCloudDeployment doExecute() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            for (AzureTask<?> t : this.subTasks) {
                t.getBody().call();
            }
            SpringCloudDeployment springCloudDeployment = this.deployment;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return springCloudDeployment;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private void startStreamingLog(boolean follow) {
        if (Objects.isNull((Object)this.deployment) || !this.openStreamingLogOnFailure) {
            return;
        }
        IAzureMessager messager = AzureMessager.getMessager();
        Optional.ofNullable(this.deployment.getLatestInstance()).ifPresent(i -> {
            messager.info(AzureString.format((String)"Opening streaming log of instance({0})...", (Object[])new Object[]{i.getName()}));
            messager.debug("###############STREAMING LOG BEGIN##################");
            CountDownLatch latch = new CountDownLatch(1);
            TailingDebouncer fireEvents = new TailingDebouncer(() -> {
                this.stopStreamingLog();
                latch.countDown();
            }, Long.valueOf(Duration.ofSeconds(15L).toMillis()).intValue());
            SpringCloudCluster service = (SpringCloudCluster)((SpringCloudApp)this.deployment.getParent()).getParent();
            this.disposable = this.deployment.getLatestInstance().streamingLogs(follow, service.isConsumptionTier() ? 300 : 500).doFinally(type -> messager.debug("###############STREAMING LOG END##################")).subscribeOn(Schedulers.boundedElastic()).subscribe(arg_0 -> DeploySpringCloudAppTask.lambda$startStreamingLog$8(messager, (Debouncer)fireEvents, arg_0));
            fireEvents.debounce();
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                this.stopStreamingLog();
            }
            finally {
                latch.countDown();
            }
        });
    }

    private void stopStreamingLog() {
        if (!this.disposable.isDisposed()) {
            this.disposable.dispose();
        }
    }

    private void startApp() {
        AzureMessager.getMessager().info(START_APP);
        if (!this.deployment.waitUntilReady(60)) {
            AzureMessager.getMessager().warning(GET_APP_STATUS_TIMEOUT);
            this.startStreamingLog(false);
        }
    }

    public SpringCloudAppConfig getConfig() {
        return this.config;
    }

    @Nonnull
    public List<AzureTask<?>> getSubTasks() {
        return this.subTasks;
    }

    public SpringCloudDeployment getDeployment() {
        return this.deployment;
    }

    public boolean isOpenStreamingLogOnFailure() {
        return this.openStreamingLogOnFailure;
    }

    public boolean isWaitDeploymentComplete() {
        return this.waitDeploymentComplete;
    }

    public Disposable getDisposable() {
        return this.disposable;
    }

    private static /* synthetic */ void lambda$startStreamingLog$8(IAzureMessager messager, Debouncer fireEvents, String s) {
        messager.debug(s);
        fireEvents.debounce();
    }

    static {
        DeploySpringCloudAppTask.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeploySpringCloudAppTask.java", DeploySpringCloudAppTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doExecute", "com.microsoft.azure.toolkit.lib.springcloud.task.DeploySpringCloudAppTask", "", "", "java.lang.Exception", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment"), 130);
    }
}

