/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage.blob;

import com.azure.core.util.paging.ContinuablePage;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.microsoft.azure.toolkit.lib.common.model.AbstractEmulatableAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.page.ItemPage;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.storage.StorageAccount;
import com.microsoft.azure.toolkit.lib.storage.blob.BlobContainer;
import com.microsoft.azure.toolkit.lib.storage.blob.BlobContainerDraft;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class BlobContainerModule
extends AbstractEmulatableAzResourceModule<BlobContainer, StorageAccount, BlobContainerClient> {
    public static final String NAME = "Azure.BlobContainer";
    private BlobServiceClient client;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public BlobContainerModule(@Nonnull StorageAccount parent) {
        super(NAME, (AzResource)parent);
    }

    protected void invalidateCache() {
        super.invalidateCache();
        this.client = null;
    }

    @Nullable
    synchronized BlobServiceClient getBlobServiceClient() {
        if (Objects.isNull(this.client) && ((StorageAccount)this.parent).exists()) {
            String connectionString = ((StorageAccount)this.parent).getConnectionString();
            this.client = new BlobServiceClientBuilder().connectionString(connectionString).buildClient();
        }
        return this.client;
    }

    @Nonnull
    protected Iterator<? extends ContinuablePage<String, BlobContainerClient>> loadResourcePagesFromAzure() {
        if (!((StorageAccount)this.parent).exists()) {
            return Collections.emptyIterator();
        }
        BlobServiceClient client = this.getBlobServiceClient();
        return Objects.requireNonNull(client).listBlobContainers().streamByPage(BlobContainerModule.getPageSize()).map(p -> new ItemPage(p.getValue().stream().map(c -> client.getBlobContainerClient(c.getName())))).iterator();
    }

    @Nullable
    protected BlobContainerClient loadResourceFromAzure(@Nonnull String name, @Nullable String resourceGroup) {
        if (!((StorageAccount)this.parent).exists()) {
            return null;
        }
        BlobServiceClient client = this.getBlobServiceClient();
        return Objects.requireNonNull(client).listBlobContainers().stream().map(s -> client.getBlobContainerClient(s.getName())).filter(c -> c.getBlobContainerName().equals(name)).findAny().orElse(null);
    }

    @AzureOperation(name="azure/storage.delete_blob_container.container", params={"nameFromResourceId(resourceId)"})
    protected void deleteResourceFromAzure(@Nonnull String resourceId) {
        String string = resourceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ResourceId id = ResourceId.fromString((String)resourceId);
            BlobServiceClient client = this.getBlobServiceClient();
            Objects.requireNonNull(client).deleteBlobContainer(id.name());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    protected BlobContainerDraft newDraftForCreate(@Nonnull String name, @Nullable String resourceGroupName) {
        return new BlobContainerDraft(name, this);
    }

    @Nonnull
    protected BlobContainer newResource(@Nonnull BlobContainerClient r) {
        return new BlobContainer(r.getBlobContainerName(), this);
    }

    @Nonnull
    protected BlobContainer newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new BlobContainer(name, this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Blob Container";
    }

    static {
        BlobContainerModule.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BlobContainerModule.java", BlobContainerModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "deleteResourceFromAzure", "com.microsoft.azure.toolkit.lib.storage.blob.BlobContainerModule", "java.lang.String", "resourceId", "", "void"), 76);
    }
}

