/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage.share;

import com.azure.storage.file.share.ShareDirectoryClient;
import com.azure.storage.file.share.ShareFileClient;
import com.azure.storage.file.share.models.ShareFileItem;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.storage.model.StorageFile;
import com.microsoft.azure.toolkit.lib.storage.share.IShareFile;
import com.microsoft.azure.toolkit.lib.storage.share.ShareFile;
import com.microsoft.azure.toolkit.lib.storage.share.ShareFileModule;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ShareFileDraft
extends ShareFile
implements StorageFile.Draft<ShareFile, ShareFileItem> {
    @Nullable
    private final ShareFile origin;
    private Boolean directory;
    private Path sourceFile;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    ShareFileDraft(@Nonnull String name, @Nonnull ShareFileModule module) {
        super(name, module);
        this.origin = null;
    }

    ShareFileDraft(@Nonnull ShareFile origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
    }

    @Nonnull
    @AzureOperation(name="azure/storage.create_share_file.file", params={"this.getName()"})
    public ShareFileItem createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ShareFileModule module = (ShareFileModule)this.getModule();
            ShareDirectoryClient client = module.getClient();
            if (Objects.isNull(client)) {
                throw new AzureToolkitRuntimeException(String.format("parent directory(%s) doesn't exist.", ((IShareFile)module.getParent()).getName()));
            }
            IAzureMessager messager = AzureMessager.getMessager();
            if (this.isDirectory()) {
                messager.info(AzureString.format((String)"Start creating directory ({0}).", (Object[])new Object[]{this.getName()}));
                client.createSubdirectory(this.getName());
                messager.success(AzureString.format((String)"Directory ({0}) is successfully created.", (Object[])new Object[]{this.getName()}));
            } else if (Objects.nonNull(this.sourceFile)) {
                messager.info(AzureString.format((String)"Start uploading file ({0}).", (Object[])new Object[]{this.sourceFile.getFileName()}));
                client.createFile(this.getName(), FileUtils.sizeOf((File)this.sourceFile.toFile())).uploadFromFile(this.sourceFile.toString());
                messager.success(AzureString.format((String)"File ({0}) is successfully uploaded.", (Object[])new Object[]{this.sourceFile.getFileName()}));
            } else {
                messager.info(AzureString.format((String)"Start creating file ({0}).", (Object[])new Object[]{this.getName()}));
                client.createFile(this.getName(), 0L);
                messager.success(AzureString.format((String)"File ({0}) is successfully created.", (Object[])new Object[]{this.getName()}));
            }
            ShareFileItem shareFileItem = Objects.requireNonNull(module.loadResourceFromAzure(this.getName(), ((IShareFile)this.getParent()).getResourceGroupName()));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return shareFileItem;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="azure/storage.update_share_file.file", params={"this.getName()"})
    public ShareFileItem updateResourceInAzure(@Nonnull ShareFileItem origin) {
        ShareFileItem shareFileItem = origin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)shareFileItem);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ShareFileModule module = (ShareFileModule)this.getModule();
            String name = origin.getName();
            ShareDirectoryClient dirClient = module.getClient();
            if (Objects.isNull(dirClient)) {
                throw new AzureToolkitRuntimeException(String.format("parent directory(%s) doesn't exist.", ((IShareFile)module.getParent()).getName()));
            }
            ShareFileClient client = dirClient.getFileClient(name);
            if (Objects.nonNull(this.sourceFile)) {
                IAzureMessager messager = AzureMessager.getMessager();
                messager.info(AzureString.format((String)"Start updating file ({0})", (Object[])new Object[]{this.getName()}));
                client.deleteIfExists();
                client.create(FileUtils.sizeOf((File)this.sourceFile.toFile()));
                client.uploadFromFile(this.sourceFile.toString());
                messager.success(AzureString.format((String)"File ({0}) is successfully updated.", (Object[])new Object[]{this.getName()}));
            }
            ShareFileItem shareFileItem2 = Objects.requireNonNull(module.loadResourceFromAzure(this.getName(), ((IShareFile)this.getParent()).getResourceGroupName()));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return shareFileItem2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    public boolean isDirectory() {
        return Optional.ofNullable(this.directory).orElseGet(() -> super.isDirectory());
    }

    public boolean isModified() {
        return false;
    }

    @Nullable
    public ShareFile getOrigin() {
        return this.origin;
    }

    @Override
    public void setDirectory(Boolean directory) {
        this.directory = directory;
    }

    @Override
    public void setSourceFile(Path sourceFile) {
        this.sourceFile = sourceFile;
    }

    static {
        ShareFileDraft.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ShareFileDraft.java", ShareFileDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.storage.share.ShareFileDraft", "", "", "", "com.azure.storage.file.share.models.ShareFileItem"), 55);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.storage.share.ShareFileDraft", "com.azure.storage.file.share.models.ShareFileItem", "origin", "", "com.azure.storage.file.share.models.ShareFileItem"), 83);
    }
}

