/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.storage.StorageManager;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzService;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.storage.AzuriteStorageAccount;
import com.microsoft.azure.toolkit.lib.storage.StorageAccount;
import com.microsoft.azure.toolkit.lib.storage.StorageAccountModule;
import com.microsoft.azure.toolkit.lib.storage.StorageServiceSubscription;
import com.microsoft.azure.toolkit.lib.storage.model.Kind;
import com.microsoft.azure.toolkit.lib.storage.model.Performance;
import com.microsoft.azure.toolkit.lib.storage.model.Redundancy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureStorageAccount
extends AbstractAzService<StorageServiceSubscription, StorageManager> {
    private static final Logger log = LoggerFactory.getLogger(AzureStorageAccount.class);

    public AzureStorageAccount() {
        super("Microsoft.Storage");
    }

    @Nonnull
    public StorageAccountModule accounts(@Nonnull String subscriptionId) {
        StorageServiceSubscription rm = (StorageServiceSubscription)this.get(subscriptionId, null);
        assert (rm != null);
        return rm.getStorageModule();
    }

    @Nullable
    public StorageAccount account(@Nonnull String resourceId) {
        ResourceId id = ResourceId.fromString((String)resourceId);
        StorageServiceSubscription rm = (StorageServiceSubscription)this.get(id.subscriptionId(), null);
        assert (rm != null);
        return (StorageAccount)rm.getStorageModule().get(resourceId);
    }

    @Nonnull
    public List<StorageAccount> accounts() {
        return this.accounts(false);
    }

    @Nonnull
    public List<StorageAccount> accounts(boolean includeLocalEmulator) {
        ArrayList<StorageAccount> result = new ArrayList<StorageAccount>();
        if (includeLocalEmulator) {
            result.add(AzuriteStorageAccount.AZURITE_STORAGE_ACCOUNT);
        }
        if (((AzureAccount)Azure.az(AzureAccount.class)).isLoggedIn()) {
            this.list().stream().flatMap(m -> m.storageAccounts().list().stream()).forEachOrdered(result::add);
        }
        return result;
    }

    @Nonnull
    protected StorageManager loadResourceFromAzure(@Nonnull String subscriptionId, @Nullable String resourceGroup) {
        Account account = ((AzureAccount)Azure.az(AzureAccount.class)).account();
        AzureConfiguration config = Azure.az().config();
        String userAgent = config.getUserAgent();
        HttpLogDetailLevel logLevel = Optional.ofNullable(config.getLogLevel()).map(HttpLogDetailLevel::valueOf).orElse(HttpLogDetailLevel.NONE);
        AzureProfile azureProfile = new AzureProfile(null, subscriptionId, account.getEnvironment());
        return ((StorageManager.Configurable)((StorageManager.Configurable)((StorageManager.Configurable)StorageManager.configure().withHttpClient(AbstractAzServiceSubscription.getDefaultHttpClient())).withLogLevel(logLevel)).withPolicy(AbstractAzServiceSubscription.getUserAgentPolicy((String)userAgent))).authenticate(account.getTokenCredential(subscriptionId), azureProfile);
    }

    @Nonnull
    protected StorageServiceSubscription newResource(@Nonnull StorageManager remote) {
        return new StorageServiceSubscription(remote, this);
    }

    @Nonnull
    public List<Performance> listSupportedPerformances() {
        return Performance.values();
    }

    @Nonnull
    public List<Kind> listSupportedKinds(@Nonnull Performance performance) {
        return Kind.values().stream().filter(k -> Objects.equals(k.getPerformance(), performance)).collect(Collectors.toList());
    }

    @Nonnull
    public List<Redundancy> listSupportedRedundancies(@Nonnull Performance performance, @Nullable Kind kind) {
        return Redundancy.values().stream().filter(r -> Objects.equals(r.getPerformance(), performance)).filter(r -> !Objects.equals(Kind.PAGE_BLOB_STORAGE, kind) || !Objects.equals(r, Redundancy.PREMIUM_ZRS)).collect(Collectors.toList());
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Storage accounts";
    }

    @Nullable
    public <E> E getById(@NotNull String id) {
        if (StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/azurite/providers/Microsoft.Storage/storageAccounts/azurite")) {
            return (E)((Object)AzuriteStorageAccount.AZURITE_STORAGE_ACCOUNT);
        }
        return (E)super.getById(id);
    }

    public boolean isAuthRequiredForListing() {
        return false;
    }
}

