/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage;

import com.azure.resourcemanager.storage.StorageManager;
import com.azure.resourcemanager.storage.models.SkuName;
import com.azure.resourcemanager.storage.models.StorageAccount;
import com.azure.resourcemanager.storage.models.StorageAccountSkuType;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.storage.StorageAccount;
import com.microsoft.azure.toolkit.lib.storage.StorageAccountModule;
import com.microsoft.azure.toolkit.lib.storage.StorageServiceSubscription;
import com.microsoft.azure.toolkit.lib.storage.model.AccessTier;
import com.microsoft.azure.toolkit.lib.storage.model.Kind;
import com.microsoft.azure.toolkit.lib.storage.model.Performance;
import com.microsoft.azure.toolkit.lib.storage.model.Redundancy;
import com.microsoft.azure.toolkit.lib.storage.model.StorageAccountConfig;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class StorageAccountDraft
extends StorageAccount
implements AzResource.Draft<StorageAccount, com.azure.resourcemanager.storage.models.StorageAccount> {
    @Nullable
    private final StorageAccount origin;
    @Nullable
    private Config config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    StorageAccountDraft(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull StorageAccountModule module) {
        super(name, resourceGroupName, module);
        this.origin = null;
    }

    StorageAccountDraft(@Nonnull StorageAccount origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
        this.config = null;
    }

    @Nonnull
    @AzureOperation(name="azure/storage.create_account.account", params={"this.getName()"})
    public com.azure.resourcemanager.storage.models.StorageAccount createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            String name = this.getName();
            StorageManager manager = Objects.requireNonNull((StorageManager)((StorageServiceSubscription)this.getParent()).getRemote());
            StorageAccount.DefinitionStages.WithCreate withCreate = ((StorageAccount.DefinitionStages.WithCreate)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)manager.storageAccounts().define(name)).withRegion(this.getRegion().getName())).withExistingResourceGroup(this.getResourceGroupName())).withSku(StorageAccountSkuType.fromSkuName((SkuName)SkuName.fromString((String)this.getRedundancy().getName())));
            Kind kind = this.getKind();
            withCreate = Objects.equals(Kind.STORAGE, kind) ? withCreate.withGeneralPurposeAccountKind() : (Objects.equals(Kind.FILE_STORAGE, kind) ? withCreate.withFileStorageAccountKind() : (Objects.equals(Kind.BLOCK_BLOB_STORAGE, kind) ? withCreate.withBlockBlobStorageAccountKind() : (Objects.equals(Kind.BLOB_STORAGE, kind) ? withCreate.withBlobStorageAccountKind().withAccessTier((com.azure.resourcemanager.storage.models.AccessTier)Optional.ofNullable(this.getAccessTier()).map(t -> com.azure.resourcemanager.storage.models.AccessTier.fromString((String)t.toString())).orElse(null)) : withCreate.withGeneralPurposeAccountKindV2())));
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(AzureString.format((String)"Start creating Storage Account({0})...", (Object[])new Object[]{name}));
            com.azure.resourcemanager.storage.models.StorageAccount account = (com.azure.resourcemanager.storage.models.StorageAccount)withCreate.create();
            messager.success(AzureString.format((String)"Storage Account({0}) is successfully created.", (Object[])new Object[]{name}));
            com.azure.resourcemanager.storage.models.StorageAccount storageAccount = account;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return storageAccount;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="azure/storage.update_account.account", params={"this.getName()"})
    public com.azure.resourcemanager.storage.models.StorageAccount updateResourceInAzure(@Nonnull com.azure.resourcemanager.storage.models.StorageAccount origin) {
        com.azure.resourcemanager.storage.models.StorageAccount storageAccount = origin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)storageAccount);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            throw new AzureToolkitRuntimeException("not supported");
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    private synchronized Config ensureConfig() {
        this.config = Optional.ofNullable(this.config).orElseGet(Config::new);
        return this.config;
    }

    public void setConfig(@Nonnull StorageAccountConfig storageAccount) {
        this.setRegion(storageAccount.getRegion());
        this.setPerformance(storageAccount.getPerformance());
        this.setKind(storageAccount.getKind());
        this.setRedundancy(storageAccount.getRedundancy());
        this.setAccessTier(storageAccount.getAccessTier());
    }

    public void setRegion(@Nonnull Region region) {
        this.ensureConfig().setRegion(region);
    }

    @Override
    @Nullable
    public Region getRegion() {
        return Objects.requireNonNull(Optional.ofNullable(this.config).map(Config::getRegion).orElseGet(() -> super.getRegion()));
    }

    @Override
    @Nullable
    public Performance getPerformance() {
        return Optional.ofNullable(this.config).map(Config::getPerformance).orElseGet(() -> super.getPerformance());
    }

    public void setPerformance(@Nonnull Performance performance) {
        this.ensureConfig().setPerformance(performance);
    }

    @Override
    @Nullable
    public Kind getKind() {
        return Optional.ofNullable(this.config).map(Config::getKind).orElseGet(() -> super.getKind());
    }

    public void setKind(@Nonnull Kind kind) {
        this.ensureConfig().setKind(kind);
    }

    @Override
    @Nullable
    public Redundancy getRedundancy() {
        return Optional.ofNullable(this.config).map(Config::getRedundancy).orElseGet(() -> super.getRedundancy());
    }

    public void setRedundancy(@Nonnull Redundancy redundancy) {
        this.ensureConfig().setRedundancy(redundancy);
    }

    @Override
    @Nullable
    public AccessTier getAccessTier() {
        return Optional.ofNullable(this.config).map(Config::getAccessTier).orElseGet(() -> super.getAccessTier());
    }

    public void setAccessTier(@Nonnull AccessTier tier) {
        this.ensureConfig().setAccessTier(tier);
    }

    public boolean isModified() {
        boolean notModified = Objects.isNull(this.config) || Objects.isNull(this.config.getRegion()) || Objects.equals(this.config.getRegion(), super.getRegion()) || Objects.isNull(this.config.getPerformance()) || Objects.equals(this.config.getPerformance(), super.getPerformance()) || Objects.isNull(this.config.getKind()) || Objects.equals(this.config.getKind(), super.getKind()) || Objects.isNull(this.config.getRedundancy()) || Objects.equals(this.config.getRedundancy(), super.getRedundancy()) || Objects.isNull((Object)this.config.getAccessTier()) || Objects.equals((Object)this.config.getAccessTier(), (Object)super.getAccessTier());
        return !notModified;
    }

    @Nullable
    public StorageAccount getOrigin() {
        return this.origin;
    }

    static {
        StorageAccountDraft.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("StorageAccountDraft.java", StorageAccountDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.storage.StorageAccountDraft", "", "", "", "com.azure.resourcemanager.storage.models.StorageAccount"), 57);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.storage.StorageAccountDraft", "com.azure.resourcemanager.storage.models.StorageAccount", "origin", "", "com.azure.resourcemanager.storage.models.StorageAccount"), 88);
    }

    @Nullable
    private static class Config {
        private Region region;
        private Performance performance;
        private Kind kind;
        private Redundancy redundancy;
        private AccessTier accessTier;

        public Region getRegion() {
            return this.region;
        }

        public Performance getPerformance() {
            return this.performance;
        }

        public Kind getKind() {
            return this.kind;
        }

        public Redundancy getRedundancy() {
            return this.redundancy;
        }

        public AccessTier getAccessTier() {
            return this.accessTier;
        }

        public void setRegion(Region region) {
            this.region = region;
        }

        public void setPerformance(Performance performance) {
            this.performance = performance;
        }

        public void setKind(Kind kind) {
            this.kind = kind;
        }

        public void setRedundancy(Redundancy redundancy) {
            this.redundancy = redundancy;
        }

        public void setAccessTier(AccessTier accessTier) {
            this.accessTier = accessTier;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Region this$region = this.getRegion();
            Region other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            Performance this$performance = this.getPerformance();
            Performance other$performance = other.getPerformance();
            if (this$performance == null ? other$performance != null : !((Object)this$performance).equals(other$performance)) {
                return false;
            }
            Kind this$kind = this.getKind();
            Kind other$kind = other.getKind();
            if (this$kind == null ? other$kind != null : !((Object)this$kind).equals(other$kind)) {
                return false;
            }
            Redundancy this$redundancy = this.getRedundancy();
            Redundancy other$redundancy = other.getRedundancy();
            if (this$redundancy == null ? other$redundancy != null : !((Object)this$redundancy).equals(other$redundancy)) {
                return false;
            }
            AccessTier this$accessTier = this.getAccessTier();
            AccessTier other$accessTier = other.getAccessTier();
            return !(this$accessTier == null ? other$accessTier != null : !((Object)((Object)this$accessTier)).equals((Object)other$accessTier));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Region $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            Performance $performance = this.getPerformance();
            result = result * 59 + ($performance == null ? 43 : ((Object)$performance).hashCode());
            Kind $kind = this.getKind();
            result = result * 59 + ($kind == null ? 43 : ((Object)$kind).hashCode());
            Redundancy $redundancy = this.getRedundancy();
            result = result * 59 + ($redundancy == null ? 43 : ((Object)$redundancy).hashCode());
            AccessTier $accessTier = this.getAccessTier();
            result = result * 59 + ($accessTier == null ? 43 : ((Object)((Object)$accessTier)).hashCode());
            return result;
        }

        public String toString() {
            return "StorageAccountDraft.Config(region=" + this.getRegion() + ", performance=" + this.getPerformance() + ", kind=" + this.getKind() + ", redundancy=" + this.getRedundancy() + ", accessTier=" + (Object)((Object)this.getAccessTier()) + ")";
        }
    }
}

