/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage.blob;

import com.azure.core.util.BinaryData;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.models.BlobItem;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.storage.blob.BlobFile;
import com.microsoft.azure.toolkit.lib.storage.blob.BlobFileModule;
import com.microsoft.azure.toolkit.lib.storage.blob.IBlobFile;
import com.microsoft.azure.toolkit.lib.storage.model.StorageFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class BlobFileDraft
extends BlobFile
implements StorageFile.Draft<BlobFile, BlobItem> {
    @Nullable
    private final BlobFile origin;
    private Boolean directory;
    private String relativePath;
    private Path sourceFile;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    BlobFileDraft(@Nonnull String name, @Nonnull BlobFileModule module) {
        super(name, module);
        this.origin = null;
    }

    BlobFileDraft(@Nonnull BlobFile origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
    }

    @Nonnull
    @AzureOperation(name="azure/storage.create_blob.blob", params={"this.getName()"})
    public BlobItem createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            BlobFileModule module = (BlobFileModule)this.getModule();
            String fullPath = Paths.get(((IBlobFile)this.getParent()).getPath(), (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.relativePath, this.getName()})).toString();
            BlobContainerClient containerClient = module.getClient();
            if (Objects.isNull(containerClient)) {
                throw new AzureToolkitRuntimeException(String.format("Blob Container (%s) doesn't exist.", ((IBlobFile)module.getParent()).getName()));
            }
            BlobClient client = containerClient.getBlobClient(fullPath);
            IAzureMessager messager = AzureMessager.getMessager();
            if (Objects.nonNull(this.sourceFile)) {
                messager.info(AzureString.format((String)"Start uploading file ({0}).", (Object[])new Object[]{this.sourceFile.getFileName()}));
                client.uploadFromFile(this.sourceFile.toString());
                messager.success(AzureString.format((String)"File ({0}) is successfully uploaded.", (Object[])new Object[]{this.sourceFile.getFileName()}));
            } else {
                messager.info(AzureString.format((String)"Start creating Blob ({0}).", (Object[])new Object[]{fullPath}));
                client.upload(BinaryData.fromString((String)""));
                messager.success(AzureString.format((String)"Blob ({0}) is successfully created.", (Object[])new Object[]{fullPath}));
            }
            BlobItem blobItem = Objects.requireNonNull(module.loadResourceFromAzure(this.getName(), ((IBlobFile)this.getParent()).getResourceGroupName()));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return blobItem;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="azure/storage.update_blob.blob", params={"this.getName()"})
    public BlobItem updateResourceInAzure(@Nonnull BlobItem origin) {
        BlobItem blobItem = origin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)blobItem);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            BlobFileModule module = (BlobFileModule)this.getModule();
            String fullPath = origin.getName();
            BlobContainerClient containerClient = module.getClient();
            if (Objects.isNull(containerClient)) {
                throw new AzureToolkitRuntimeException(String.format("Blob Container (%s) doesn't exist.", ((IBlobFile)module.getParent()).getName()));
            }
            BlobClient client = containerClient.getBlobClient(fullPath);
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(AzureString.format((String)"Start updating Blob ({0})", (Object[])new Object[]{fullPath}));
            if (Objects.nonNull(this.sourceFile)) {
                client.uploadFromFile(this.sourceFile.toString(), true);
            }
            messager.info(AzureString.format((String)"Blob ({0}) is successfully updated.", (Object[])new Object[]{fullPath}));
            BlobItem blobItem2 = Objects.requireNonNull(module.loadResourceFromAzure(this.getName(), ((IBlobFile)this.getParent()).getResourceGroupName()));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return blobItem2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    public boolean isDirectory() {
        return Optional.ofNullable(this.directory).orElseGet(() -> super.isDirectory());
    }

    public boolean isModified() {
        return false;
    }

    @Nullable
    public BlobFile getOrigin() {
        return this.origin;
    }

    @Override
    public void setDirectory(Boolean directory) {
        this.directory = directory;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    @Override
    public void setSourceFile(Path sourceFile) {
        this.sourceFile = sourceFile;
    }

    static {
        BlobFileDraft.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BlobFileDraft.java", BlobFileDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.storage.blob.BlobFileDraft", "", "", "", "com.azure.storage.blob.models.BlobItem"), 59);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.storage.blob.BlobFileDraft", "com.azure.storage.blob.models.BlobItem", "origin", "", "com.azure.storage.blob.models.BlobItem"), 83);
    }
}

