/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage.queue;

import com.azure.core.util.Context;
import com.azure.core.util.paging.ContinuablePage;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.storage.queue.QueueClient;
import com.azure.storage.queue.QueueServiceClient;
import com.azure.storage.queue.QueueServiceClientBuilder;
import com.azure.storage.queue.models.QueuesSegmentOptions;
import com.microsoft.azure.toolkit.lib.common.model.AbstractEmulatableAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.page.ItemPage;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.storage.StorageAccount;
import com.microsoft.azure.toolkit.lib.storage.queue.Queue;
import com.microsoft.azure.toolkit.lib.storage.queue.QueueDraft;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class QueueModule
extends AbstractEmulatableAzResourceModule<Queue, StorageAccount, QueueClient> {
    public static final String NAME = "Azure.Queue";
    private QueueServiceClient client;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public QueueModule(@Nonnull StorageAccount parent) {
        super(NAME, (AzResource)parent);
    }

    protected void invalidateCache() {
        super.invalidateCache();
        this.client = null;
    }

    @Nullable
    synchronized QueueServiceClient getQueueServiceClient() {
        if (Objects.isNull(this.client) && ((StorageAccount)this.parent).exists()) {
            String connectionString = ((StorageAccount)this.parent).getConnectionString();
            this.client = new QueueServiceClientBuilder().connectionString(connectionString).buildClient();
        }
        return this.client;
    }

    @Nonnull
    protected Iterator<? extends ContinuablePage<String, QueueClient>> loadResourcePagesFromAzure() {
        if (!((StorageAccount)this.parent).exists()) {
            return Collections.emptyIterator();
        }
        QueueServiceClient client = this.getQueueServiceClient();
        return Objects.requireNonNull(client).listQueues(new QueuesSegmentOptions().setIncludeMetadata(true), null, Context.NONE).streamByPage(QueueModule.getPageSize()).map(p -> new ItemPage(p.getValue().stream().map(s -> client.getQueueClient(s.getName())))).iterator();
    }

    @Nullable
    protected QueueClient loadResourceFromAzure(@Nonnull String name, @Nullable String resourceGroup) {
        if (!((StorageAccount)this.parent).exists()) {
            return null;
        }
        QueueServiceClient client = this.getQueueServiceClient();
        Stream<QueueClient> resources = Objects.requireNonNull(client).listQueues(new QueuesSegmentOptions().setIncludeMetadata(true), null, Context.NONE).stream().map(s -> client.getQueueClient(s.getName()));
        return resources.filter(c -> c.getQueueName().equals(name)).findAny().orElse(null);
    }

    @AzureOperation(name="azure/storage.delete_queue.queue", params={"nameFromResourceId(resourceId)"})
    protected void deleteResourceFromAzure(@Nonnull String resourceId) {
        String string = resourceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ResourceId id = ResourceId.fromString((String)resourceId);
            QueueServiceClient client = this.getQueueServiceClient();
            Objects.requireNonNull(client).deleteQueue(id.name());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    protected QueueDraft newDraftForCreate(@Nonnull String name, @Nullable String resourceGroupName) {
        return new QueueDraft(name, this);
    }

    @Nonnull
    protected Queue newResource(@Nonnull QueueClient r) {
        return new Queue(r, this);
    }

    @Nonnull
    protected Queue newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new Queue(name, this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Queue";
    }

    static {
        QueueModule.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("QueueModule.java", QueueModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "deleteResourceFromAzure", "com.microsoft.azure.toolkit.lib.storage.queue.QueueModule", "java.lang.String", "resourceId", "", "void"), 77);
    }
}

