/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage.share;

import com.azure.storage.common.sas.SasProtocol;
import com.azure.storage.file.share.ShareClient;
import com.azure.storage.file.share.ShareDirectoryClient;
import com.azure.storage.file.share.ShareFileClient;
import com.azure.storage.file.share.sas.ShareFileSasPermission;
import com.azure.storage.file.share.sas.ShareSasPermission;
import com.azure.storage.file.share.sas.ShareServiceSasSignatureValues;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.storage.model.StorageFile;
import com.microsoft.azure.toolkit.lib.storage.share.Share;
import java.time.OffsetDateTime;
import java.util.Objects;

public interface IShareFile
extends StorageFile {
    public Share getShare();

    @Override
    default public String getSasUrl() {
        String token;
        String shareUrl = this.getShare().getUrl();
        OffsetDateTime expiration = OffsetDateTime.now().plusDays(1L);
        if (this instanceof Share) {
            ShareClient client = this.getShare().getShareClient();
            if (Objects.isNull(client)) {
                throw new AzureToolkitRuntimeException(String.format("File Share %s doesn't exist.", this.getName()));
            }
            ShareSasPermission sharePermission = new ShareSasPermission().setReadPermission(true).setListPermission(true);
            ShareServiceSasSignatureValues builder = new ShareServiceSasSignatureValues(expiration, sharePermission).setProtocol(SasProtocol.HTTPS_ONLY);
            token = client.generateSas(builder);
        } else {
            Object client = this.getClient();
            if (Objects.isNull(client)) {
                throw new AzureToolkitRuntimeException(String.format("%s doesn't exist.", this.getName()));
            }
            ShareFileSasPermission filePermission = new ShareFileSasPermission().setReadPermission(true);
            ShareServiceSasSignatureValues builder = new ShareServiceSasSignatureValues(expiration, filePermission).setProtocol(SasProtocol.HTTPS_ONLY);
            token = this.isDirectory() ? ((ShareDirectoryClient)client).generateSas(builder) : ((ShareFileClient)client).generateSas(builder);
        }
        return String.format("%s/%s?%s", shareUrl, this.getPath(), token);
    }
}

