/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage.blob;

import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.models.BlobContainerProperties;
import com.azure.storage.blob.specialized.BlobClientBase;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AbstractEmulatableAzResource;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.storage.IStorageAccount;
import com.microsoft.azure.toolkit.lib.storage.blob.BlobContainerModule;
import com.microsoft.azure.toolkit.lib.storage.blob.BlobFileModule;
import com.microsoft.azure.toolkit.lib.storage.blob.IBlobFile;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BlobContainer
extends AbstractEmulatableAzResource<BlobContainer, IStorageAccount, BlobContainerClient>
implements Deletable,
IBlobFile {
    private final BlobFileModule subFileModule;

    protected BlobContainer(@Nonnull String name, @Nonnull BlobContainerModule module) {
        super(name, (AbstractAzResourceModule)module);
        this.subFileModule = new BlobFileModule(this);
    }

    public BlobContainer(@Nonnull BlobContainer origin) {
        super((AbstractAzResource)origin);
        this.subFileModule = origin.subFileModule;
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.subFileModule);
    }

    @Nonnull
    protected String loadStatus(@Nonnull BlobContainerClient remote) {
        return "";
    }

    @Override
    @Nullable
    public BlobContainerClient getClient() {
        BlobContainerModule module = (BlobContainerModule)this.getModule();
        return Optional.ofNullable(module.getBlobServiceClient()).map(c -> c.getBlobContainerClient(this.getName())).orElse(null);
    }

    public boolean exists(String blobPath) {
        return Optional.ofNullable(this.getClient()).map(c -> c.getBlobClient(blobPath)).map(BlobClientBase::exists).orElse(false);
    }

    @Override
    @Nullable
    public OffsetDateTime getLastModified() {
        return this.remoteOptional().map(BlobContainerClient::getProperties).map(BlobContainerProperties::getLastModified).orElse(null);
    }

    @Override
    public String getPath() {
        return "";
    }

    @Override
    public BlobContainer getContainer() {
        return this;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public String getUrl() {
        return Optional.ofNullable(this.getClient()).map(BlobContainerClient::getBlobContainerUrl).orElse("");
    }

    @Override
    public void download(OutputStream output) {
    }

    @Override
    public void download(Path dest) {
    }

    public BlobFileModule getSubFileModule() {
        return this.subFileModule;
    }
}

