/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage.share;

import com.azure.storage.file.share.ShareClient;
import com.azure.storage.file.share.ShareDirectoryClient;
import com.azure.storage.file.share.ShareServiceClient;
import com.azure.storage.file.share.models.ShareProperties;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AbstractEmulatableAzResource;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.storage.IStorageAccount;
import com.microsoft.azure.toolkit.lib.storage.share.IShareFile;
import com.microsoft.azure.toolkit.lib.storage.share.ShareFileModule;
import com.microsoft.azure.toolkit.lib.storage.share.ShareModule;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Share
extends AbstractEmulatableAzResource<Share, IStorageAccount, ShareClient>
implements Deletable,
IShareFile {
    private final ShareFileModule subFileModule;

    protected Share(@Nonnull String name, @Nonnull ShareModule module) {
        super(name, (AbstractAzResourceModule)module);
        this.subFileModule = new ShareFileModule(this);
    }

    public Share(@Nonnull Share origin) {
        super((AbstractAzResource)origin);
        this.subFileModule = origin.subFileModule;
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.subFileModule);
    }

    @Nonnull
    protected String loadStatus(@Nonnull ShareClient remote) {
        return "";
    }

    @Nullable
    public ShareDirectoryClient getClient() {
        return Optional.ofNullable(this.getShareClient()).map(ShareClient::getRootDirectoryClient).orElse(null);
    }

    @Nullable
    public ShareClient getShareClient() {
        ShareModule module = (ShareModule)this.getModule();
        ShareServiceClient fileShareServiceClient = module.getFileShareServiceClient();
        return Optional.ofNullable(fileShareServiceClient).map(c -> c.getShareClient(this.getName())).orElse(null);
    }

    @Override
    public Share getShare() {
        return this;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public String getPath() {
        return "";
    }

    @Override
    public String getUrl() {
        return Optional.ofNullable(this.getShareClient()).map(ShareClient::getShareUrl).orElse("");
    }

    @Override
    @Nullable
    public OffsetDateTime getLastModified() {
        return this.remoteOptional().map(ShareClient::getProperties).map(ShareProperties::getLastModified).orElse(null);
    }

    @Override
    public void download(OutputStream output) {
    }

    @Override
    public void download(Path dest) {
    }

    public ShareFileModule getSubFileModule() {
        return this.subFileModule;
    }
}

