/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage.model;

import com.google.common.collect.ImmutableList;
import com.microsoft.azure.toolkit.lib.common.model.ExpandableParameter;
import com.microsoft.azure.toolkit.lib.storage.model.Performance;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class Kind
implements ExpandableParameter {
    public static final Kind STORAGE = new Kind(Performance.STANDARD, "Storage", "General Purpose v1");
    public static final Kind STORAGE_V2 = new Kind(Performance.STANDARD, "StorageV2", "General Purpose v2");
    public static final Kind BLOB_STORAGE = new Kind(Performance.PREMIUM, "BlobStorage", "Blob Storage");
    public static final Kind BLOCK_BLOB_STORAGE = new Kind(Performance.PREMIUM, "BlockBlobStorage", "Block Blobs Storage");
    public static final Kind FILE_STORAGE = new Kind(Performance.PREMIUM, "FileStorage", "File Storage");
    public static final Kind PAGE_BLOB_STORAGE = new Kind(Performance.PREMIUM, "StorageV2", "Page Blobs Storage");
    private static final List<Kind> values = new ImmutableList.Builder().add((Object[])new Kind[]{STORAGE, STORAGE_V2, BLOCK_BLOB_STORAGE, FILE_STORAGE, PAGE_BLOB_STORAGE}).build();
    private final Performance performance;
    private final String name;
    private final String label;

    private Kind(Performance performance, String name, String label) {
        this.performance = performance;
        this.name = name;
        this.label = label;
    }

    public static List<Kind> values() {
        return values;
    }

    @Nonnull
    public static Kind fromName(@Nonnull String value) {
        return Kind.values().stream().filter(region -> StringUtils.equalsAnyIgnoreCase((CharSequence)value, (CharSequence[])new CharSequence[]{region.name, region.label})).findFirst().orElse(new Kind(Performance.STANDARD, value, value));
    }

    public boolean isExpandedValue() {
        return !Kind.values().contains(this);
    }

    public Performance getPerformance() {
        return this.performance;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Kind)) {
            return false;
        }
        Kind other = (Kind)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Performance this$performance = this.getPerformance();
        Performance other$performance = other.getPerformance();
        if (this$performance == null ? other$performance != null : !((Object)this$performance).equals(other$performance)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        return !(this$label == null ? other$label != null : !this$label.equals(other$label));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Kind;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Performance $performance = this.getPerformance();
        result = result * 59 + ($performance == null ? 43 : ((Object)$performance).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        return result;
    }
}

