/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.common.function.handlers.artifact;

import com.microsoft.azure.common.deploytarget.DeployTarget;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.function.AzureStorageHelper;
import com.microsoft.azure.common.function.handlers.artifact.FunctionArtifactHelper;
import com.microsoft.azure.common.handlers.artifact.ArtifactHandlerBase;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobContainerPermissions;
import com.microsoft.azure.storage.blob.BlobContainerPublicAccessType;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.File;
import java.net.URISyntaxException;
import java.time.Period;
import org.apache.commons.lang3.StringUtils;

public class RunFromBlobArtifactHandlerImpl
extends ArtifactHandlerBase {
    private static final int SAS_EXPIRE_DATE_BY_YEAR = 10;
    private static final String DEPLOYMENT_PACKAGE_CONTAINER = "java-functions-run-from-packages";
    private static final String FAILED_TO_GET_FUNCTION_APP_ARTIFACT_CONTAINER = "Failed to get Function App artifact container";
    private static final String UPDATE_ACCESS_LEVEL_TO_PRIVATE = "The blob container '%s' access level was updated to be private";

    protected RunFromBlobArtifactHandlerImpl(Builder builder) {
        super(builder);
    }

    public void publish(DeployTarget deployTarget) throws AzureExecutionException {
        File zipPackage = FunctionArtifactHelper.createFunctionArtifact(this.stagingDirectoryPath);
        CloudStorageAccount storageAccount = FunctionArtifactHelper.getCloudStorageAccount(deployTarget);
        CloudBlockBlob blob = this.deployArtifactToAzureStorage(deployTarget, zipPackage, storageAccount);
        String sasToken = AzureStorageHelper.getSASToken((CloudBlob)blob, Period.ofYears(10));
        FunctionArtifactHelper.updateAppSetting(deployTarget, "WEBSITE_RUN_FROM_PACKAGE", sasToken);
    }

    private CloudBlockBlob deployArtifactToAzureStorage(DeployTarget deployTarget, File zipPackage, CloudStorageAccount storageAccount) throws AzureExecutionException {
        Log.prompt(String.format("Trying to deploy artifact to %s...", deployTarget.getName()));
        CloudBlobContainer container = this.getOrCreateArtifactContainer(storageAccount);
        String blobName = this.getBlobName((WebAppBase)deployTarget.getApp(), zipPackage);
        CloudBlockBlob blob = AzureStorageHelper.uploadFileAsBlob(zipPackage, storageAccount, container.getName(), blobName, BlobContainerPublicAccessType.OFF);
        String blobUri = blob.getUri().getHost() + blob.getUri().getPath();
        Log.prompt(String.format("Successfully deployed the artifact to https://%s", blobUri));
        return blob;
    }

    private CloudBlobContainer getOrCreateArtifactContainer(CloudStorageAccount storageAccount) throws AzureExecutionException {
        CloudBlobClient blobContainer = storageAccount.createCloudBlobClient();
        try {
            CloudBlobContainer container = blobContainer.getContainerReference(DEPLOYMENT_PACKAGE_CONTAINER);
            if (!container.exists()) {
                container.createIfNotExists(BlobContainerPublicAccessType.OFF, null, null);
            } else {
                this.updateContainerPublicAccessLevel(container);
            }
            return container;
        }
        catch (StorageException | URISyntaxException e) {
            throw new AzureExecutionException(FAILED_TO_GET_FUNCTION_APP_ARTIFACT_CONTAINER, e);
        }
    }

    private void updateContainerPublicAccessLevel(CloudBlobContainer container) throws StorageException {
        BlobContainerPermissions permissions = container.downloadPermissions();
        if (permissions.getPublicAccess() == BlobContainerPublicAccessType.OFF) {
            return;
        }
        permissions.setPublicAccess(BlobContainerPublicAccessType.OFF);
        container.uploadPermissions(permissions);
        Log.info(String.format(UPDATE_ACCESS_LEVEL_TO_PRIVATE, DEPLOYMENT_PACKAGE_CONTAINER));
    }

    private String getBlobName(WebAppBase deployTarget, File zipPackage) {
        String fixedResourceId = StringUtils.replace((String)deployTarget.id(), (String)"/", (String)"-").replaceFirst("-", "");
        return String.format("%s-%s", fixedResourceId, zipPackage.getName());
    }

    public static class Builder
    extends ArtifactHandlerBase.Builder<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RunFromBlobArtifactHandlerImpl build() {
            return new RunFromBlobArtifactHandlerImpl(this);
        }
    }
}

