/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.common.logging;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Log {
    private static Logger logger = LoggerFactory.getLogger(Log.class);

    public static void error(String message) {
        logger.error(message);
    }

    public static void error(Exception error) {
        logger.error(Log.getErrorDetail(error));
    }

    public static void info(String message) {
        logger.info(message);
    }

    public static void info(Exception error) {
        logger.info(Log.getErrorDetail(error));
    }

    public static void debug(String message) {
        logger.debug(message);
    }

    public static void debug(Exception error) {
        logger.debug(Log.getErrorDetail(error));
    }

    public static void warn(String message) {
        logger.warn(message);
    }

    public static void warn(Exception error) {
        logger.warn(Log.getErrorDetail(error));
    }

    public static boolean isDebugEnabled() {
        return logger.isDebugEnabled();
    }

    public static void prompt(String message) {
        if (logger.isInfoEnabled()) {
            logger.info(message);
        } else {
            System.out.println(message);
        }
    }

    private static String getErrorDetail(Exception error) {
        StringWriter sw = new StringWriter();
        error.printStackTrace(new PrintWriter(sw));
        String exceptionDetails = sw.toString();
        try {
            sw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return exceptionDetails;
    }
}

