/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.tools.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import rx.Observable;
import rx.schedulers.Schedulers;

public class RxUtils {
    private static final int POLLING_INTERVAL = 1;

    public static <T> T pollUntil(Callable<T> callable, Predicate<T> predicate, int timeOutInSeconds) {
        return RxUtils.pollUntil(callable, predicate, timeOutInSeconds, 1);
    }

    public static <T> T pollUntil(Callable<T> callable, Predicate<T> predicate, int timeOutInSeconds, int pollingInterval) {
        long timeout = System.currentTimeMillis() + (long)(timeOutInSeconds * 1000);
        return (T)Observable.interval((long)pollingInterval, (TimeUnit)TimeUnit.SECONDS).timeout((long)timeOutInSeconds, TimeUnit.SECONDS).flatMap(aLong -> Observable.fromCallable((Callable)callable)).subscribeOn(Schedulers.io()).takeUntil(resource -> predicate.test(resource) || System.currentTimeMillis() > timeout).toBlocking().last();
    }
}

