/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.common;

import com.microsoft.azure.common.appservice.OperatingSystemEnum;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import java.util.Locale;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public final class Utils {
    public static OperatingSystemEnum parseOperationSystem(String os) throws AzureExecutionException {
        if (StringUtils.isEmpty((CharSequence)os)) {
            throw new AzureExecutionException("The value of 'os' is empty, please specify it in 'runtime' configuration.");
        }
        switch (os.toLowerCase(Locale.ENGLISH)) {
            case "windows": {
                return OperatingSystemEnum.Windows;
            }
            case "linux": {
                return OperatingSystemEnum.Linux;
            }
            case "docker": {
                return OperatingSystemEnum.Docker;
            }
        }
        throw new AzureExecutionException("The value of <os> is unknown, supported values are: windows, linux and docker.");
    }

    public static boolean isGUID(String input) {
        try {
            return UUID.fromString(input).toString().equalsIgnoreCase(input);
        }
        catch (Exception e) {
            return false;
        }
    }
}

