/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.common.applicationinsights;

import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ApplicationInsightsComponent;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ApplicationType;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.InsightsManager;
import com.microsoft.azure.management.resources.ResourceGroup;

public class ApplicationInsightsManager {
    private Azure azure;
    private InsightsManager insightsManager;

    public ApplicationInsightsManager(AzureTokenCredentials tokenCredentials, String subscriptionId, String userAgent) {
        this.azure = ((Azure.Configurable)Azure.configure().withUserAgent(userAgent)).authenticate(tokenCredentials).withSubscription(subscriptionId);
        this.insightsManager = ((InsightsManager.Configurable)InsightsManager.configure().withUserAgent(userAgent)).authenticate(tokenCredentials, subscriptionId);
    }

    public ApplicationInsightsComponent getApplicationInsightsInstance(String resourceGroup, String name) {
        try {
            return (ApplicationInsightsComponent)this.insightsManager.components().getByResourceGroup(resourceGroup, name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ApplicationInsightsComponent createApplicationInsights(String resourceGroup, String name, String location) {
        if (!this.azure.resourceGroups().contain(resourceGroup)) {
            ((ResourceGroup.DefinitionStages.WithCreate)((ResourceGroup.DefinitionStages.Blank)this.azure.resourceGroups().define(resourceGroup)).withRegion(location)).create();
        }
        return (ApplicationInsightsComponent)((ApplicationInsightsComponent.DefinitionStages.WithApplicationType)((ApplicationInsightsComponent.DefinitionStages.WithGroup)((ApplicationInsightsComponent.DefinitionStages.Blank)this.insightsManager.components().define(name)).withRegion(location)).withExistingResourceGroup(resourceGroup)).withApplicationType(ApplicationType.WEB).withKind("web").create();
    }
}

