/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.common;

import com.microsoft.azure.common.appservice.OperatingSystemEnum;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Locale;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class Utils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getArtifactCompileVersion(File artifact) throws AzureExecutionException {
        try (JarFile jarFile = new JarFile(artifact);){
            JarEntry jarEntry = jarFile.stream().filter(entry -> StringUtils.endsWith((CharSequence)entry.getName(), (CharSequence)".class")).findFirst().orElseThrow(() -> new AzureExecutionException("Failed to parse artifact compile version, no class file founded in target artifact"));
            InputStream stream = jarFile.getInputStream(jarEntry);
            byte[] version = new byte[2];
            stream.skip(6L);
            stream.read(version);
            stream.close();
            int majorVersion = new BigInteger(version).intValueExact() - 44;
            String string = majorVersion > 8 ? String.valueOf(majorVersion) : String.format("1.%d", majorVersion);
            return string;
        }
        catch (IOException e) {
            throw new AzureExecutionException("Failed to parse artifact compile version.", e);
        }
    }

    public static OperatingSystemEnum parseOperationSystem(String os) throws AzureExecutionException {
        if (StringUtils.isEmpty((CharSequence)os)) {
            throw new AzureExecutionException("The value of 'os' is empty, please specify it in 'runtime' configuration.");
        }
        switch (os.toLowerCase(Locale.ENGLISH)) {
            case "windows": {
                return OperatingSystemEnum.Windows;
            }
            case "linux": {
                return OperatingSystemEnum.Linux;
            }
            case "docker": {
                return OperatingSystemEnum.Docker;
            }
        }
        throw new AzureExecutionException("The value of <os> is unknown, supported values are: windows, linux and docker.");
    }

    public static boolean isGUID(String input) {
        try {
            return UUID.fromString(input).toString().equalsIgnoreCase(input);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getSegment(String id, String segment) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        Object[] attributes = id.split("/");
        int pos = ArrayUtils.indexOf((Object[])attributes, (Object)segment);
        if (pos >= 0) {
            return attributes[pos + 1];
        }
        return null;
    }
}

