/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.common.function.handlers.artifact;

import com.microsoft.azure.common.deploytarget.DeployTarget;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.management.appservice.AppSetting;
import com.microsoft.azure.management.appservice.DeploymentSlotBase;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.FunctionDeploymentSlot;
import com.microsoft.azure.storage.CloudStorageAccount;
import java.io.File;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.zeroturnaround.zip.ZipUtil;

public class FunctionArtifactHelper {
    private static final String STAGE_DIR_NOT_FOUND = "Azure Functions stage directory not found. Please run 'mvn clean azure-functions:package' first.";
    private static final String INTERNAL_STORAGE_NOT_FOUND = "Application setting 'AzureWebJobsStorage' not found.";
    private static final String UNSUPPORTED_DEPLOYMENT_TARGET = "Unsupported deployment target, only function is supported";

    public static File createFunctionArtifact(String stagingDirectoryPath) throws AzureExecutionException {
        File stageDirectory = new File(stagingDirectoryPath);
        File zipPackage = new File(stagingDirectoryPath.concat(".zip"));
        if (!stageDirectory.exists() || !stageDirectory.isDirectory()) {
            throw new AzureExecutionException(STAGE_DIR_NOT_FOUND);
        }
        ZipUtil.pack((File)stageDirectory, (File)zipPackage);
        ZipUtil.removeEntry((File)zipPackage, (String)"local.settings.json");
        return zipPackage;
    }

    public static void updateAppSetting(DeployTarget deployTarget, String key, String value) throws AzureExecutionException {
        Object targetApp = deployTarget.getApp();
        if (targetApp instanceof FunctionApp) {
            ((FunctionApp.Update)((FunctionApp)targetApp).update()).withAppSetting(key, value).apply();
        } else if (targetApp instanceof FunctionDeploymentSlot) {
            ((DeploymentSlotBase.Update)((FunctionDeploymentSlot)targetApp).update()).withAppSetting(key, value).apply();
        } else {
            throw new AzureExecutionException(UNSUPPORTED_DEPLOYMENT_TARGET);
        }
    }

    public static CloudStorageAccount getCloudStorageAccount(DeployTarget target) throws AzureExecutionException {
        String value;
        AppSetting setting;
        Map<String, AppSetting> settingsMap = target.getAppSettings();
        if (settingsMap != null && (setting = settingsMap.get("AzureWebJobsStorage")) != null && StringUtils.isNotEmpty((CharSequence)(value = setting.value()))) {
            try {
                return CloudStorageAccount.parse((String)value);
            }
            catch (URISyntaxException | InvalidKeyException e) {
                throw new AzureExecutionException("Cannot parse storage connection string due to error: " + e.getMessage(), e);
            }
        }
        throw new AzureExecutionException(INTERNAL_STORAGE_NOT_FOUND);
    }
}

