/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.common.function.handlers.runtime;

import com.microsoft.azure.common.appservice.DockerImageType;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.function.handlers.runtime.AbstractLinuxFunctionRuntimeHandler;
import com.microsoft.azure.common.function.handlers.runtime.FunctionRuntimeHandler;
import com.microsoft.azure.common.utils.AppServiceUtils;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.DeploymentSlotBase;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.FunctionDeploymentSlot;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.WebAppBase;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.RandomUtils;

public class DockerFunctionRuntimeHandler
extends AbstractLinuxFunctionRuntimeHandler {
    private static final String INVALID_DOCKER_RUNTIME = "Invalid docker runtime configured.";

    protected DockerFunctionRuntimeHandler(Builder builder) {
        super((FunctionRuntimeHandler.Builder)builder);
    }

    @Override
    public FunctionApp.DefinitionStages.WithCreate defineAppWithRuntime() throws AzureExecutionException {
        FunctionApp.DefinitionStages.WithCreate result;
        DockerImageType imageType = AppServiceUtils.getDockerImageType(this.image, this.dockerCredentialProvider != null, this.registryUrl);
        this.checkFunctionExtensionVersion();
        this.checkConfiguration(imageType);
        FunctionApp.DefinitionStages.WithDockerContainerImage withDockerContainerImage = super.defineLinuxFunction();
        switch (imageType) {
            case PUBLIC_DOCKER_HUB: {
                result = withDockerContainerImage.withPublicDockerHubImage(this.image);
                break;
            }
            case PRIVATE_DOCKER_HUB: {
                result = withDockerContainerImage.withPrivateDockerHubImage(this.image).withCredentials(this.dockerCredentialProvider.getUsername(), this.dockerCredentialProvider.getPassword());
                break;
            }
            case PRIVATE_REGISTRY: {
                result = withDockerContainerImage.withPrivateRegistryImage(this.image, this.registryUrl).withCredentials(this.dockerCredentialProvider.getUsername(), this.dockerCredentialProvider.getPassword());
                break;
            }
            default: {
                throw new AzureExecutionException(INVALID_DOCKER_RUNTIME);
            }
        }
        String decryptionKey = this.generateDecryptionKey();
        return (FunctionApp.DefinitionStages.WithCreate)result.withAppSetting("MACHINEKEY_DecryptionKey", decryptionKey).withAppSetting("WEBSITES_ENABLE_APP_SERVICE_STORAGE", "false").withAppSetting("FUNCTION_APP_EDIT_MODE", "readOnly");
    }

    @Override
    public FunctionApp.Update updateAppRuntime(FunctionApp app) throws AzureExecutionException {
        DockerImageType imageType = AppServiceUtils.getDockerImageType(this.image, this.dockerCredentialProvider != null, this.registryUrl);
        this.checkFunctionExtensionVersion();
        this.checkConfiguration(imageType);
        FunctionApp.Update update = (FunctionApp.Update)app.update();
        switch (imageType) {
            case PUBLIC_DOCKER_HUB: {
                return update.withPublicDockerHubImage(this.image);
            }
            case PRIVATE_DOCKER_HUB: {
                return update.withPrivateDockerHubImage(this.image).withCredentials(this.dockerCredentialProvider.getUsername(), this.dockerCredentialProvider.getPassword());
            }
            case PRIVATE_REGISTRY: {
                return update.withPrivateRegistryImage(this.image, this.registryUrl).withCredentials(this.dockerCredentialProvider.getUsername(), this.dockerCredentialProvider.getPassword());
            }
        }
        throw new AzureExecutionException(INVALID_DOCKER_RUNTIME);
    }

    @Override
    public WebAppBase.Update<FunctionDeploymentSlot> updateDeploymentSlot(FunctionDeploymentSlot deploymentSlot) throws AzureExecutionException {
        DockerImageType imageType = AppServiceUtils.getDockerImageType(this.image, this.dockerCredentialProvider != null, this.registryUrl);
        this.checkFunctionExtensionVersion();
        this.checkConfiguration(imageType);
        DeploymentSlotBase.Update update = (DeploymentSlotBase.Update)deploymentSlot.update();
        switch (imageType) {
            case PUBLIC_DOCKER_HUB: {
                return update.withPublicDockerHubImage(this.image);
            }
            case PRIVATE_DOCKER_HUB: {
                return update.withPrivateDockerHubImage(this.image).withCredentials(this.dockerCredentialProvider.getUsername(), this.dockerCredentialProvider.getPassword());
            }
            case PRIVATE_REGISTRY: {
                return update.withPrivateRegistryImage(this.image, this.registryUrl).withCredentials(this.dockerCredentialProvider.getUsername(), this.dockerCredentialProvider.getPassword());
            }
        }
        throw new AzureExecutionException(INVALID_DOCKER_RUNTIME);
    }

    protected void checkConfiguration(DockerImageType imageType) throws AzureExecutionException {
        PricingTier appServicePricingTier;
        if (imageType != DockerImageType.PUBLIC_DOCKER_HUB) {
            if (this.dockerCredentialProvider == null) {
                throw new AzureExecutionException("Cannot get docker credential for private image.");
            }
            this.dockerCredentialProvider.validate();
        }
        AppServicePlan appServicePlan = this.getAppServicePlan();
        Object object = this.pricingTier != null ? this.pricingTier : (appServicePricingTier = appServicePlan != null ? appServicePlan.pricingTier() : null);
        if (appServicePricingTier == null) {
            throw new AzureExecutionException("Consumption plan is not supported for docker functions.");
        }
    }

    protected String generateDecryptionKey() {
        return Hex.encodeHexString((byte[])RandomUtils.nextBytes((int)32)).toUpperCase();
    }

    public static class Builder
    extends FunctionRuntimeHandler.Builder<Builder> {
        @Override
        public DockerFunctionRuntimeHandler build() {
            return new DockerFunctionRuntimeHandler(this.self());
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

