/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.maven.AbstractAzureMojo;
import com.microsoft.azure.maven.webapp.configuration.ContainerSetting;
import com.microsoft.azure.maven.webapp.configuration.DeploymentType;
import com.microsoft.azure.maven.webapp.configuration.PricingTierEnum;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractWebAppMojo
extends AbstractAzureMojo {
    @Parameter(property="webapp.resourceGroup", required=true)
    protected String resourceGroup;
    @Parameter(property="webapp.appName", required=true)
    protected String appName;
    @Parameter(property="webapp.region", defaultValue="westus")
    protected String region;
    @Parameter(property="webapp.pricingTier", defaultValue="S1")
    protected PricingTierEnum pricingTier;
    @Parameter(property="webapp.javaVersion")
    protected String javaVersion;
    @Parameter(property="webapp.javaWebContainer", defaultValue="tomcat 8.5")
    protected String javaWebContainer;
    @Parameter
    protected ContainerSetting containerSettings;
    @Parameter
    protected Properties appSettings;
    @Parameter(property="webapp.deploymentType")
    protected String deploymentType;
    @Parameter
    protected List<Resource> resources;

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getRegion() {
        return this.region;
    }

    public PricingTier getPricingTier() {
        return this.pricingTier == null ? PricingTier.STANDARD_S1 : this.pricingTier.toPricingTier();
    }

    public JavaVersion getJavaVersion() {
        return StringUtils.isEmpty((String)this.javaVersion) ? null : JavaVersion.fromString((String)this.javaVersion);
    }

    public WebContainer getJavaWebContainer() {
        return StringUtils.isEmpty((String)this.javaWebContainer) ? WebContainer.TOMCAT_8_5_NEWEST : WebContainer.fromString((String)this.javaWebContainer);
    }

    public ContainerSetting getContainerSettings() {
        return this.containerSettings;
    }

    public Map getAppSettings() {
        return this.appSettings;
    }

    public DeploymentType getDeploymentType() throws MojoExecutionException {
        return DeploymentType.fromString(this.deploymentType);
    }

    public String getDeploymentStageDirectory() {
        return Paths.get(this.getBuildDirectoryAbsolutePath(), "azure-webapps", this.getAppName()).toString();
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public WebApp getWebApp() {
        try {
            return (WebApp)this.getAzureClient().webApps().getByResourceGroup(this.getResourceGroup(), this.getAppName());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

