/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.DeployFacade;
import com.microsoft.azure.maven.webapp.WebAppUtils;
import com.microsoft.azure.maven.webapp.configuration.ContainerSetting;
import com.microsoft.azure.maven.webapp.handlers.ArtifactHandler;
import com.microsoft.azure.maven.webapp.handlers.FTPArtifactHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.JavaRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.NullRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.PrivateDockerHubRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.PrivateRegistryRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.PublicDockerHubRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.RuntimeHandler;
import com.microsoft.azure.maven.webapp.handlers.SettingsHandler;
import com.microsoft.azure.maven.webapp.handlers.SettingsHandlerImpl;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class DeployFacadeBaseImpl
implements DeployFacade {
    public static final String NO_RESOURCES_CONFIG = "No resources specified in pom.xml. Skip artifacts deployment.";
    public static final String RUNTIME_CONFIG_CONFLICT = "<javaVersion> is for Web App on Windows; <containerSettings> is for Web App on Linux; they can't be specified at the same time.";
    public static final String NO_RUNTIME_HANDLER = "Not able to process the runtime stack configuration; please check <javaVersion> or <containerSettings> tag.";
    private AbstractWebAppMojo mojo;

    public DeployFacadeBaseImpl(AbstractWebAppMojo mojo) {
        this.mojo = mojo;
    }

    @Override
    public abstract DeployFacade setupRuntime() throws MojoExecutionException;

    @Override
    public abstract DeployFacade applySettings() throws MojoExecutionException;

    @Override
    public abstract DeployFacade commitChanges() throws MojoExecutionException;

    @Override
    public DeployFacade deployArtifacts() throws Exception {
        List<Resource> resources = this.getMojo().getResources();
        if (resources == null || resources.isEmpty()) {
            this.getMojo().getLog().info((CharSequence)NO_RESOURCES_CONFIG);
        } else {
            this.getArtifactHandler().publish(resources);
        }
        return this;
    }

    protected AbstractWebAppMojo getMojo() {
        return this.mojo;
    }

    protected RuntimeHandler getRuntimeHandler() throws MojoExecutionException {
        JavaVersion javaVersion = this.getMojo().getJavaVersion();
        ContainerSetting containerSetting = this.getMojo().getContainerSettings();
        if (javaVersion == null && (containerSetting == null || containerSetting.isEmpty())) {
            return new NullRuntimeHandlerImpl(this.getMojo());
        }
        if (javaVersion != null && containerSetting != null && !containerSetting.isEmpty()) {
            throw new MojoExecutionException(RUNTIME_CONFIG_CONFLICT);
        }
        if (javaVersion != null) {
            return new JavaRuntimeHandlerImpl(this.getMojo());
        }
        if (WebAppUtils.isPublicDockerHubImage(containerSetting)) {
            return new PublicDockerHubRuntimeHandlerImpl(this.getMojo());
        }
        if (WebAppUtils.isPrivateDockerHubImage(containerSetting)) {
            return new PrivateDockerHubRuntimeHandlerImpl(this.getMojo());
        }
        if (WebAppUtils.isPrivateRegistryImage(containerSetting)) {
            return new PrivateRegistryRuntimeHandlerImpl(this.getMojo());
        }
        throw new MojoExecutionException(NO_RUNTIME_HANDLER);
    }

    protected SettingsHandler getSettingsHandler() {
        return new SettingsHandlerImpl(this.getMojo());
    }

    protected ArtifactHandler getArtifactHandler() throws MojoExecutionException {
        switch (this.getMojo().getDeploymentType()) {
            default: 
        }
        return new FTPArtifactHandlerImpl(this.getMojo());
    }
}

